import gtk

import null_backend


class GtkNull(object):

	def __init__(self, widgetTree):
		"""
		@note Thread agnostic
		"""
		self._projectsCombo = widgetTree.get_widget("projectsCombo")
		self._addTaskButton = widgetTree.get_widget("add-addTaskButton")

		self._todoBox = widgetTree.get_widget("todoBox")
		self._todoAreaFiller = gtk.Label()

		self._manager = null_backend.NullManager("", "")

	@staticmethod
	def name():
		return "None"

	def load_settings(self, config):
		pass

	def save_settings(self, config):
		pass

	def login(self):
		pass

	def logout(self):
		pass

	def enable(self):
		"""
		@note UI Thread
		"""
		self._projectsCombo.set_sensitive(False)
		self._addTaskButton.set_sensitive(False)

		self._todoBox.pack_start(self._todoAreaFiller)
		self._todoAreaFiller.show_all()

	def disable(self):
		"""
		@note UI Thread
		"""
		self._todoBox.remove(self._todoAreaFiller)
		self._todoAreaFiller.hide_all()

		self._projectsCombo.set_sensitive(True)
		self._addTaskButton.set_sensitive(True)
