#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QComboBox>
#include <QPushButton>

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QString &aAppletId, QWidget *parent = 0);
    ~SettingsDialog();

    void dumpSettings() const;

public slots:
    void btnColorClicked();
    void fontChanged(int aIndex);

private slots:
    void showAbout();
    void showQtAbout();
    void rotateToggle(bool);

private:
    void loadSettings();
    void buildFontList();
//    void fillCbTZ();
    int calcOffset() const;
    void fillTZlist(QComboBox* &aBox);

private:
    QString m_appletId;
    Ui::SettingsDialog *ui;
    QFont m_font;
//    int m_defTZoffset;
};

#endif // SETTINGSDIALOG_H
