#include <QColorDialog>
#include <QColor>
#include <QMessageBox>
#include <QFontDatabase>
#include <QDateTime>
//#include <QStateMachine>

#if defined(Q_WS_MAEMO_5)
#include <cityinfo.h>
#include <clockd/libtime.h>
#endif

#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "dclocksettings.h"

#define STR_VERSION "0.4.3"
#define STR_CRLF "<br>"
#define STR_QT_VERSION "<b>Qt 4.6.2</b>"
#define STR_COPYRIGHT "Copyright (c) 2010 Avis"
#define STR_EMAIL "<a href=\"mailto:avis@allnokia.ru\">avis@allnokia.ru</a>"
#define STR_DONATE "<a href=https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=TBV3R4AU2PVHS>Donate</a>"

SettingsDialog::SettingsDialog(QString &aAppletId, QWidget *parent) :
    QDialog(parent), m_appletId(aAppletId),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    buildFontList();
    ui->chbBold->setEnabled(false);
    ui->chbItalic->setEnabled(false);
    fillTZlist(ui->cbTZ);

    rotateToggle(false);
    loadSettings();
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

/*void SettingsDialog::fillCbTZ()
{
    ui->cbTZ->addItem("UTC-12",-43200);
    ui->cbTZ->addItem("UTC-11",-39600);
    ui->cbTZ->addItem("UTC-10",-36000);
    ui->cbTZ->addItem("UTC-9",-32400);
    ui->cbTZ->addItem("UTC-8",-28800);
    ui->cbTZ->addItem("UTC-7",-25200);
    ui->cbTZ->addItem("UTC-6",-21600);
    ui->cbTZ->addItem("UTC-5",-18000);
    ui->cbTZ->addItem("UTC-4:30",-16200);
    ui->cbTZ->addItem("UTC-4",-14400);
    ui->cbTZ->addItem("UTC-3:30",-12600);
    ui->cbTZ->addItem("UTC-3",-10800);
    ui->cbTZ->addItem("UTC-2",-7200);
    ui->cbTZ->addItem("UTC-1",-3600);
    ui->cbTZ->addItem("UTC+0",0);
    ui->cbTZ->addItem("UTC+1",3600);
    ui->cbTZ->addItem("UTC+2",7200);
    ui->cbTZ->addItem("UTC+3",10800);
    ui->cbTZ->addItem("UTC+3:30",12600);
    ui->cbTZ->addItem("UTC+4",14400);
    ui->cbTZ->addItem("UTC+4:30",16200);
    ui->cbTZ->addItem("UTC+5",18000);
    ui->cbTZ->addItem("UTC+5:30",19800);
    ui->cbTZ->addItem("UTC+5:45",20700);
    ui->cbTZ->addItem("UTC+6",21600);
    ui->cbTZ->addItem("UTC+6:30",23400);
    ui->cbTZ->addItem("UTC+7",25200);
    ui->cbTZ->addItem("UTC+8",28800);
    ui->cbTZ->addItem("UTC+9",32400);
    ui->cbTZ->addItem("UTC+9:30",34200);
    ui->cbTZ->addItem("UTC+10",36000);
    ui->cbTZ->addItem("UTC+11",39600);
    ui->cbTZ->addItem("UTC+12",43200);
    ui->cbTZ->addItem("UTC+13",46800);
    ui->cbTZ->addItem("UTC+14",50400);
}
*/
void SettingsDialog::buildFontList()
{
    QFontDatabase database;

    foreach (QString family, database.families()) {
        ui->cbFont->addItem(family);
        }
}

void SettingsDialog::btnColorClicked()
{
    QColor newColor = QColorDialog::getColor(ui->labelColor->palette().color(QPalette::WindowText), 0);
    if (newColor.isValid())
        {
//            ui->label->setText(newColor.name());
        QPalette qp = ui->labelColor->palette();
        qp.setColor(QPalette::WindowText,newColor);
        ui->labelColor->setPalette(qp);
        }
}

void SettingsDialog::dumpSettings() const
{
    dclocksettings::getInstance().setColor(m_appletId,ui->labelColor->palette().color(QPalette::WindowText));
    dclocksettings::getInstance().setShowSeconds(m_appletId,ui->checkBox->isChecked());
    dclocksettings::getInstance().setTimeFormat(m_appletId,ui->cbTimeFormat->currentIndex());
    int w = ui->spinWidth->value();
    int h = ui->spinHeight->value();
    dclocksettings::getInstance().setSize(m_appletId,QSize(w,h));
    if (ui->cbFont->currentIndex() == 0)
        dclocksettings::getInstance().setLcd(m_appletId,true);
    else
        dclocksettings::getInstance().setLcd(m_appletId,false);
    dclocksettings::getInstance().setFont(m_appletId,m_font);
    dclocksettings::getInstance().setBlinking(m_appletId,ui->chbBlink->isChecked());
    int tzIndex = ui->cbTZ->currentIndex();
    int tzOffset = ui->cbTZ->itemData(tzIndex,Qt::UserRole).toInt();
    int defOffest = calcOffset();
    if (tzOffset == defOffest)
        dclocksettings::getInstance().setTZoffset(m_appletId,-50000);
    else
        dclocksettings::getInstance().setTZoffset(m_appletId,tzOffset);
    dclocksettings::getInstance().setTZindex(m_appletId,tzIndex);
    QString tzCity = ui->cbTZ->currentText();
    int strpos1 = tzCity.indexOf(",");
    int strpos2 = tzCity.indexOf(",",strpos1+1);
    tzCity = tzCity.mid(strpos1+2,strpos2-strpos1-2);
    if (tzCity.isEmpty())
        tzCity = "unknown";
    dclocksettings::getInstance().setTZcity(m_appletId,tzCity);
    dclocksettings::getInstance().setTransparency(m_appletId,ui->hzSliderTransparency->value());
    dclocksettings::getInstance().setRotateEnabled(m_appletId,ui->chbRotate->isChecked());
    dclocksettings::getInstance().setOpenClockEnabled(m_appletId,ui->chbOpenClock->isChecked());
    dclocksettings::getInstance().setShowCityEnabled(m_appletId,ui->chbShowCity->isChecked());
    dclocksettings::getInstance().setCitySize(m_appletId,ui->spinCitySize->value());
    int aCorner;
    if (ui->rbTL->isChecked())
        aCorner = 1;
    if (ui->rbTR->isChecked())
        aCorner = 2;
    if (ui->rbBR->isChecked())
        aCorner = 3;
    if (ui->rbBL->isChecked())
        aCorner = 4;
    dclocksettings::getInstance().setCornerNumber(m_appletId,aCorner);

    dclocksettings::getInstance().setShowDateEnabled(m_appletId,ui->cbShowDate->isChecked());
    dclocksettings::getInstance().setFullDateFormat(m_appletId,ui->cbFullDate->isChecked());
    dclocksettings::getInstance().setDateSize(m_appletId,ui->spinDateSize->value());
}

int SettingsDialog::calcOffset() const
{
    QDateTime dt = QDateTime::currentDateTime();
    QDateTime udt = dt.toUTC();
    QTime tm = dt.time();
    QTime utm = udt.time();
    return utm.secsTo(tm);
}

void SettingsDialog::loadSettings()
{
    QColor dColor = dclocksettings::getInstance().getColor(m_appletId);
    QPalette qp = ui->labelColor->palette();
    qp.setColor(QPalette::WindowText,dColor);
    ui->labelColor->setPalette(qp);
    ui->checkBox->setChecked(dclocksettings::getInstance().isShowSeconds(m_appletId));
    ui->cbTimeFormat->setCurrentIndex(dclocksettings::getInstance().getTimeFormat(m_appletId));
    QSize wSize = dclocksettings::getInstance().getSize(m_appletId);
    ui->spinWidth->setValue(wSize.width());
    ui->spinHeight->setValue(wSize.height());
    ui->chbBlink->setChecked(dclocksettings::getInstance().isBlinking(m_appletId));
    ui->hzSliderTransparency->setValue(dclocksettings::getInstance().getTransparency(m_appletId));
    ui->chbRotate->setChecked(dclocksettings::getInstance().isRotateEnabled(m_appletId));
    ui->chbOpenClock->setChecked(dclocksettings::getInstance().isOpenClockEnabled(m_appletId));
    ui->chbShowCity->setChecked(dclocksettings::getInstance().isShowCityEnabled(m_appletId));
    ui->spinCitySize->setValue(dclocksettings::getInstance().getCitySize(m_appletId));

    ui->cbShowDate->setChecked(dclocksettings::getInstance().isShowDateEnabled(m_appletId));
    ui->cbFullDate->setChecked(dclocksettings::getInstance().isFullDateFormat(m_appletId));
    ui->spinDateSize->setValue(dclocksettings::getInstance().getDateSize(m_appletId));

    int aCorner = dclocksettings::getInstance().getCornerNumber(m_appletId);
    switch (aCorner)
    {
    case 1:
        ui->rbTL->setChecked(true);
        break;
    case 2:
        ui->rbTR->setChecked(true);
        break;
    case 3:
        ui->rbBR->setChecked(true);
        break;
    case 4:
        ui->rbBL->setChecked(true);
        break;
    }

//    int tzOffset = dclocksettings::getInstance().getTZoffset(m_appletId);
    int tzIndex = dclocksettings::getInstance().getTZindex(m_appletId);
//    QString tzCity = dclocksettings::getInstance().getTZcity(m_appletId);
    if (tzIndex > -1)
    {
        ui->cbTZ->setCurrentIndex(tzIndex);
    }
//    if (tzOffset != -50000)
  //  {
        // calc current time zone
/*        QDateTime dt = QDateTime::currentDateTime();
        QDateTime udt = dt.toUTC();
        QTime tm = dt.time();
        QTime utm = udt.time();*/
//        tzOffset = calcOffset();
//        m_defTZoffset = tzOffset; // save current TZ offset
//    }
//    int i = ui->cbTZ->findData(tzOffset, int(Qt::UserRole));
//    ui->cbTZ->setCurrentIndex(i);

    if (dclocksettings::getInstance().isLcd(m_appletId))
        ui->cbFont->setCurrentIndex(0);
    else
    {
        bool found = false;
        m_font = dclocksettings::getInstance().getFont(m_appletId);
        QString fnt_family(m_font.family());
        int i;
        for (i = 1; i < ui->cbFont->count(); i++)
        {
        if (ui->cbFont->itemText(i) == fnt_family)
            {
            found = true;
            break;
        }
        }
        if (found)
        {
            ui->chbBold->setEnabled(true);
            ui->chbItalic->setEnabled(true);
            ui->chbBold->setChecked(m_font.bold());
            ui->chbItalic->setChecked(m_font.italic());
            ui->labelColor->setFont(m_font);
            ui->cbFont->setCurrentIndex(i);
        }
        else
            ui->cbFont->setCurrentIndex(0);
    }
}

void SettingsDialog::showAbout()
{
    QString msgName = tr("DigiClock");
    QString msgDeveloped = tr("Developed with");
    QString msgDescr = tr("Desktop widget, showing digital time");
    QString msgReports = tr("Send reports to:");
    QString msgText = "<b>" + msgName + "</b> " + STR_VERSION + STR_CRLF;
    msgText += msgDescr + STR_CRLF;
    msgText += msgDeveloped + " " + STR_QT_VERSION + STR_CRLF + STR_CRLF;
    msgText += msgReports + " " + STR_EMAIL + STR_CRLF;
    msgText += QString(STR_DONATE) + STR_CRLF + STR_CRLF;
    msgText += STR_COPYRIGHT;
    QMessageBox::about(this, tr("About DigiClock"),msgText);
}

void SettingsDialog::showQtAbout()
{
    QMessageBox::aboutQt(this);
}

void SettingsDialog::fontChanged(int aIndex)
{
    Q_UNUSED(aIndex);
    if (ui->cbFont->currentIndex() == 0)
    {
        ui->chbBold->setEnabled(false);
        ui->chbItalic->setEnabled(false);
    }
    else
    {
        ui->chbBold->setEnabled(true);
        ui->chbItalic->setEnabled(true);
        m_font.setFamily(ui->cbFont->currentText());
        m_font.setBold(ui->chbBold->isChecked());
        m_font.setItalic(ui->chbItalic->isChecked());
        ui->labelColor->setFont(m_font);
    }
}

void SettingsDialog::fillTZlist(QComboBox* &aBox)
{
#if  defined(Q_WS_MAEMO_5)
    int ret = 0;
    char current_tz[32];
    ret = time_get_timezone(&current_tz[0],32);

    QString defTZ = QString::fromUtf8(current_tz);

    aBox->clear();
    //    int k = 0; //
    Cityinfo **cities = cityinfo_get_all();
    for (int i = 0; cities && cities[i]; ++i) {

        QString name = QString::fromUtf8(cityinfo_get_name(cities[i]));
        QString country = QString::fromUtf8(cityinfo_get_country(cities[i]));
        QString zone = ":" + QString::fromUtf8(cityinfo_get_zone(cities[i]));

    //        if (zone == defTZ)
    //          k = i;

        QString timeoffset;
        QString sign;
        int offset = time_get_utc_offset(cityinfo_get_zone(cities[i]));
        if (offset > 0)
            sign = "";
        else
            sign = "+";
        if((offset % 3600)==0)
            timeoffset = QString("%2, %1, (UTC %3)").arg(name).arg(country).arg(sign+QString::number(-offset/3600));
        else
            timeoffset = QString("%2, %1, (UTC %3:%4)").arg(name).arg(country).arg(sign+QString::number(-offset/3600)).arg("30");
        aBox->addItem(timeoffset,-offset);
        if (zone == defTZ)
            defTZ = timeoffset;
    }
    cityinfo_free_all(cities);
    aBox->model()->sort(0);
    int k = aBox->findText(defTZ);
    aBox->setCurrentIndex(k);
#endif
}

void SettingsDialog::rotateToggle(bool aState)
{
    if (aState)
    {
        ui->groupBox->setEnabled(true);
    }
    else
    {
        ui->groupBox->setEnabled(false);
    }
}
