#include <QtGui>
#include "fontclock.h"

//FontClock::FontClock(QColor &aColor, QString &aFormat, QFont &aFont, int aBlink1, int aBlink2, QWidget *parent) :
//    QWidget(parent), m_font(aFont), m_color(aColor), m_format(aFormat), m_blink1(aBlink1), m_blink2(aBlink2)
FontClock::FontClock(QColor &aColor, QFont &aFont, QString &aTime, QWidget *parent) :
    QWidget(parent), m_font(aFont), m_color(aColor), m_text(aTime)
{
    QSize aa = parent->size();
    resize(aa);
//    setAttribute(Qt::WA_TranslucentBackground);

//    setWindowOpacity(0.4);
//    QPalette qp = palette();
  //  QColor qback = qp.color(QPalette::Base);
//    qback.setAlpha(100);
  //  qp.setColor(QPalette::Base,qback );
    calcFontSize();
    showTime(m_text);
}

void FontClock::calcFontSize()
{
    int wd_width = size().width();
    int wd_hgt = size().height();

//    QTime time = QTime::currentTime();
//    m_text = time.toString(m_format);

    QString fFamily = m_font.family();
    // calc font size
    for (int i = 0; i < 200; i++)
    {
        QFont f(fFamily,i);
        QFontMetrics fm(f);

        int x = fm.width(m_text);
        int y = fm.height();

        if ((x > wd_width) || (y > wd_hgt))
        {
            m_fntSize = i-1;
            break;
        }
    }
    m_font.setPointSize(m_fntSize);
}

void FontClock::showTime(QString aTime)
{
/*    QTime time = QTime::currentTime();
    m_text = time.toString(m_format);
    if (m_blink1)
    {
        int lngt = m_text.length();
        if ((time.second() % 2) == 0)
        {
            m_text[lngt-m_blink1] = ' ';
            if (m_blink2)
                m_text[lngt-m_blink2] = ' ';
        }
    }*/
    m_text = aTime;
    update();
}

void FontClock::paintEvent(QPaintEvent* /*event*/)
{
    QPainter p(this);
    p.setFont(m_font);
    p.setPen(m_color);

    p.drawText(rect(), Qt::AlignCenter, m_text);
}
