#ifndef DCLOCKSETTINGS_H
#define DCLOCKSETTINGS_H
#include <QSize>
#include <QColor>
#include <QFont>

class dclocksettings
{
public:
    static dclocksettings& getInstance()
    {
        static dclocksettings instance; // Guaranteed to be destroyed.
        // Instantiated on first use.
        return instance;
    }

    //get/set widget size;
    QSize getSize(const QString &aAplletId) const;
    void setSize(const QString &aAplletId, const QSize &aSize) const;
    //get/set color of digits
    QColor getColor(const QString &aAplletId) const;
    void setColor(const QString &aAplletId, const QColor &aColor) const;
    //get/set show seconds flag
    bool getShowSeconds(const QString &aAplletId) const;
    void setShowSeconds(const QString &aAplletId, const bool &aShow) const;
    //get/set time format
    int getTimeFormat(const QString &aAplletId) const;
    void setTimeFormat(const QString &aAplletId, const int &aFormatIdx) const;
    //get/set LCD
    bool getLcd(const QString &aAplletId) const;
    void setLcd(const QString &aAplletId, const bool &aLcd) const;
    //get/set font
    QFont getFont(const QString &aAplletId) const;
    void setFont(const QString &aAplletId, const QFont &aFont) const;
    //get/set blinking
    bool getBlinking(const QString &aAplletId) const;
    void setBlinking(const QString &aAplletId, const bool &aBlink) const;
    //get/set time zone
    int getTZoffset(const QString &aAplletId) const;
    void setTZoffset(const QString &aAplletId, const int &aOffset) const;
    //get/set transparency
    int getTransparency(const QString &aAplletId) const;
    void setTransparency(const QString &aAplletId, const int &aTrans) const;



private:
    dclocksettings() {}
    dclocksettings(dclocksettings const&);              // Don't Implement
    void operator=(dclocksettings const&); // Don't implement
};

#endif // DCLOCKSETTINGS_H
