#include "dclocksettings.h"
#include <QSettings>
#include <QVariant>

/*It's better to use QCoreApplication::setOrganizationName(), QCoreApplication::setOrganizationDomain(),
and QCoreApplication::setApplicationName(). And then only use QSettings() in any place.
But this solution is based on incapsulation strategy, and therefore if this code become a part of lib
and will be used in app without setted appropriate values for application and organization names, then it would probably
 cause some problems */

static const QString organizationName = QString("Avis");
static const QString applicationName = QString("DigiClock");


//get widget size;
QSize dclocksettings::getSize(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    //return widget size
    int wdth = sett.value("WidgetWidth",300).toInt();
    int hgth = sett.value("WidgetHeight",80).toInt();
    sett.endGroup();
    return QSize(wdth, hgth);
}

//set widget size;
void dclocksettings::setSize(const QString &aAplletId,const QSize &aSize) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("WidgetWidth",aSize.width());
    sett.setValue("WidgetHeight",aSize.height());
    sett.endGroup();
}

//get color of digits
QColor dclocksettings::getColor(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    sett.beginGroup(aAplletId);
    int r = sett.value("DigitsColorR",255).toInt();
    int g = sett.value("DigitsColorG",255).toInt();
    int b = sett.value("DigitsColorB",255).toInt();
    int a = sett.value("DigitsColorA",255).toInt();
    sett.endGroup();
    return QColor(r,g,b,a);
}

//set color of digits
void dclocksettings::setColor(const QString &aAplletId, const QColor &aColor) const
{
    QSettings sett(organizationName,applicationName);
    int r = aColor.red();
    int g = aColor.green();
    int b = aColor.blue();
    int a = aColor.alpha();
    sett.beginGroup(aAplletId);
    sett.setValue("DigitsColorR",r);
    sett.setValue("DigitsColorG",g);
    sett.setValue("DigitsColorB",b);
    sett.setValue("DigitsColorA",a);
    sett.endGroup();
}

//get show seconds flag
bool dclocksettings::getShowSeconds(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    sett.beginGroup(aAplletId);
    return sett.value("ShowSeconds",true).toBool();
}

//set show seconds flag
void dclocksettings::setShowSeconds(const QString &aAplletId, const bool &aShow) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("ShowSeconds",aShow);
    sett.endGroup();
}

//get time format
int dclocksettings::getTimeFormat(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    sett.beginGroup(aAplletId);
    return sett.value("TimeFormat",0).toInt();
}

//set time format
void dclocksettings::setTimeFormat(const QString &aAplletId,const int &aFormatIdx) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("TimeFormat",aFormatIdx);
    sett.endGroup();
}

//get LCD
bool dclocksettings::getLcd(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    sett.beginGroup(aAplletId);
    return sett.value("LcdFormat",true).toBool();
}

//set LCD
void dclocksettings::setLcd(const QString &aAplletId,const bool &aLcd) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("LcdFormat",aLcd);
    sett.endGroup();
}

//get font
QFont dclocksettings::getFont(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    //return widget size
    QFont fnt;
    sett.beginGroup(aAplletId);
    fnt.setFamily(sett.value("FontFamily",QString("Helvetica")).toString());
    fnt.setBold(sett.value("FontBold",false).toBool());
    fnt.setItalic(sett.value("FontItalic",false).toBool());
    sett.endGroup();
    return fnt;
}

//set font
void dclocksettings::setFont(const QString &aAplletId,const QFont &aFont) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("FontFamily",aFont.family());
    sett.setValue("FontBold",aFont.bold());
    sett.setValue("FontItalic",aFont.italic());
    sett.endGroup();
}

//get blinking
bool dclocksettings::getBlinking(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("DelimBlinking",true).toBool();
}

//set blinking
void dclocksettings::setBlinking(const QString &aAplletId,const bool &aBlink) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("DelimBlinking",aBlink);
    sett.endGroup();
}

//get time zone
int dclocksettings::getTZoffset(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("TimeZoneOffset",-50000).toInt();
}

//set time zone
void dclocksettings::setTZoffset(const QString &aAplletId,const int &aOffset) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("TimeZoneOffset",aOffset);
    sett.endGroup();
}

//get transparency
int dclocksettings::getTransparency(const QString &aAplletId) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    return sett.value("Transparency",100).toInt();
}

//set transparency
void dclocksettings::setTransparency(const QString &aAplletId, const int &aTrans) const
{
    QSettings sett(organizationName,applicationName);
    sett.beginGroup(aAplletId);
    sett.setValue("Transparency",aTrans);
    sett.endGroup();
}
