#include <QColorDialog>
#include <QColor>
#include <QMessageBox>
#include <QFontDatabase>
#include <QDateTime>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "dclocksettings.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    buildFontList();
    ui->chbBold->setEnabled(false);
    ui->chbItalic->setEnabled(false);
    //m_defTZoffset = -50000;
    fillCbTZ();
    loadSettings();
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::fillCbTZ()
{
    ui->cbTZ->addItem("UTC-12",-43200);
    ui->cbTZ->addItem("UTC-11",-39600);
    ui->cbTZ->addItem("UTC-10",-36000);
    ui->cbTZ->addItem("UTC-9",-32400);
    ui->cbTZ->addItem("UTC-8",-28800);
    ui->cbTZ->addItem("UTC-7",-25200);
    ui->cbTZ->addItem("UTC-6",-21600);
    ui->cbTZ->addItem("UTC-5",-18000);
    ui->cbTZ->addItem("UTC-4:30",-16200);
    ui->cbTZ->addItem("UTC-4",-14400);
    ui->cbTZ->addItem("UTC-3:30",-12600);
    ui->cbTZ->addItem("UTC-3",-10800);
    ui->cbTZ->addItem("UTC-2",-7200);
    ui->cbTZ->addItem("UTC-1",-3600);
    ui->cbTZ->addItem("UTC+0",0);
    ui->cbTZ->addItem("UTC+1",3600);
    ui->cbTZ->addItem("UTC+2",7200);
    ui->cbTZ->addItem("UTC+3",10800);
    ui->cbTZ->addItem("UTC+3:30",12600);
    ui->cbTZ->addItem("UTC+4",14400);
    ui->cbTZ->addItem("UTC+4:30",16200);
    ui->cbTZ->addItem("UTC+5",18000);
    ui->cbTZ->addItem("UTC+5:30",19800);
    ui->cbTZ->addItem("UTC+5:45",20700);
    ui->cbTZ->addItem("UTC+6",21600);
    ui->cbTZ->addItem("UTC+6:30",23400);
    ui->cbTZ->addItem("UTC+7",25200);
    ui->cbTZ->addItem("UTC+8",28800);
    ui->cbTZ->addItem("UTC+9",32400);
    ui->cbTZ->addItem("UTC+9:30",34200);
    ui->cbTZ->addItem("UTC+10",36000);
    ui->cbTZ->addItem("UTC+11",39600);
    ui->cbTZ->addItem("UTC+12",43200);
    ui->cbTZ->addItem("UTC+13",46800);
    ui->cbTZ->addItem("UTC+14",50400);
}

void SettingsDialog::buildFontList()
{
    QFontDatabase database;

    foreach (QString family, database.families()) {
        ui->cbFont->addItem(family);
        }
}

void SettingsDialog::btnColorClicked()
{
    QColor newColor = QColorDialog::getColor(ui->labelColor->palette().color(QPalette::WindowText), 0);
    if (newColor.isValid())
        {
//            ui->label->setText(newColor.name());
        QPalette qp = ui->labelColor->palette();
        qp.setColor(QPalette::WindowText,newColor);
        ui->labelColor->setPalette(qp);
        }
}

void SettingsDialog::dumpSettings() const
{
    dclocksettings::getInstance().setColor(ui->labelColor->palette().color(QPalette::WindowText));
    dclocksettings::getInstance().setShowSeconds(ui->checkBox->isChecked());
    dclocksettings::getInstance().setTimeFormat(ui->cbTimeFormat->currentIndex());
    int w = ui->spinWidth->value();
    int h = ui->spinHeight->value();
    dclocksettings::getInstance().setSize(QSize(w,h));
    if (ui->cbFont->currentIndex() == 0)
        dclocksettings::getInstance().setLcd(true);
    else
        dclocksettings::getInstance().setLcd(false);
    dclocksettings::getInstance().setFont(m_font);
    dclocksettings::getInstance().setBlinking(ui->chbBlink->isChecked());
    int tzOffset = ui->cbTZ->itemData(ui->cbTZ->currentIndex(),Qt::UserRole).toInt();
    int defOffest = calcOffset();
    if (tzOffset == defOffest)
        dclocksettings::getInstance().setTZoffset(-50000);
    else
        dclocksettings::getInstance().setTZoffset(tzOffset);
}

int SettingsDialog::calcOffset() const
{
    QDateTime dt = QDateTime::currentDateTime();
    QDateTime udt = dt.toUTC();
    QTime tm = dt.time();
    QTime utm = udt.time();
    return utm.secsTo(tm);
}

void SettingsDialog::loadSettings()
{
    QColor dColor = dclocksettings::getInstance().getColor();
    QPalette qp = ui->labelColor->palette();
    qp.setColor(QPalette::WindowText,dColor);
    ui->labelColor->setPalette(qp);
    ui->checkBox->setChecked(dclocksettings::getInstance().getShowSeconds());
    ui->cbTimeFormat->setCurrentIndex(dclocksettings::getInstance().getTimeFormat());
    QSize wSize = dclocksettings::getInstance().getSize();
    ui->spinWidth->setValue(wSize.width());
    ui->spinHeight->setValue(wSize.height());
    ui->chbBlink->setChecked(dclocksettings::getInstance().getBlinking());

    int tzOffset = dclocksettings::getInstance().getTZoffset();
    if (tzOffset == -50000)
    {
        // calc current time zone
/*        QDateTime dt = QDateTime::currentDateTime();
        QDateTime udt = dt.toUTC();
        QTime tm = dt.time();
        QTime utm = udt.time();*/
        tzOffset = calcOffset();
//        m_defTZoffset = tzOffset; // save current TZ offset
    }
    int i = ui->cbTZ->findData(tzOffset, int(Qt::UserRole));
    ui->cbTZ->setCurrentIndex(i);

    if (dclocksettings::getInstance().getLcd())
        ui->cbFont->setCurrentIndex(0);
    else
    {
        bool found = false;
        m_font = dclocksettings::getInstance().getFont();
        QString fnt_family(m_font.family());
        int i;
        for (i = 1; i < ui->cbFont->count(); i++)
        {
        if (ui->cbFont->itemText(i) == fnt_family)
            {
            found = true;
            break;
        }
        }
        if (found)
        {
            ui->chbBold->setEnabled(true);
            ui->chbItalic->setEnabled(true);
            ui->chbBold->setChecked(m_font.bold());
            ui->chbItalic->setChecked(m_font.italic());
            ui->labelColor->setFont(m_font);
            ui->cbFont->setCurrentIndex(i);
        }
        else
            ui->cbFont->setCurrentIndex(0);
    }
}

void SettingsDialog::showAbout()
{
    QString msgText = tr("<b>DigiClock</b> 0.3.0<br>"
                         "Using <b>Qt 4.6.2</b><br>"
                         "Copyright (c) 2010 Avis<br>"
                         "<a href=\"mailto:avis@allnokia.ru\">avis@allnokia.ru</a><br><br>"
                         "Desktop widget, showing digital time");
    msgText += "<br><br><a href=https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=TBV3R4AU2PVHS>Donate</a>";
    QMessageBox::about(this, tr("About DigiClock"),
                        msgText);
}

void SettingsDialog::showQtAbout()
{
    QMessageBox::aboutQt(this);
}

void SettingsDialog::fontChanged(int aIndex)
{
    if (ui->cbFont->currentIndex() == 0)
    {
        ui->chbBold->setEnabled(false);
        ui->chbItalic->setEnabled(false);
    }
    else
    {
        ui->chbBold->setEnabled(true);
        ui->chbItalic->setEnabled(true);
        m_font.setFamily(ui->cbFont->currentText());
        m_font.setBold(ui->chbBold->isChecked());
        m_font.setItalic(ui->chbItalic->isChecked());
        ui->labelColor->setFont(m_font);
    }
}
