#ifndef DIGITALCLOCKWDG_H
#define DIGITALCLOCKWDG_H

#include <QLCDNumber>

//class SettingsDialog;

class DigitalClockWdg : public QWidget
{
    Q_OBJECT

signals:
    void updateClock();

public slots:
    void showSettingsDialog();
    void homeScreenChanged(bool isOnCurrentHomescreen);

public:
    DigitalClockWdg(QWidget *parent = 0);

protected:
    void mouseReleaseEvent ( QMouseEvent * e );
    void mousePressEvent ( QMouseEvent * e );
//    void mouseMoveEvent ( QMouseEvent * e );

private slots:
    void showTime();

private:
    void loadSettings();
    void initClock();
    void showClock();

private:
    QWidget * clk1;
    bool m_lcd;
    QFont m_font;

    QTimer *m_timer;
    QColor m_digitColor;
    QSize m_size;
    int m_timer_tick;
    QString m_timeFormat;
    bool m_mouseClick;
    QPoint m_lastPoint;
    int m_blinking1;
    int m_blinking2;
};

#endif
