#include <QtGui>

#include "lcdclock.h"

LcdClock::LcdClock(QColor &aColor, QString &aFormat, int aBlink1, int aBlink2, QWidget *parent)
    : QLCDNumber(parent),  m_timeFormat(aFormat), m_blink1(aBlink1), m_blink2(aBlink2)
{
    setSegmentStyle(Filled);
    QSize aa = parent->size();
    resize(aa);
    QPalette qp;
    qp.setColor(QPalette::WindowText,aColor );
    qp.setColor(QPalette::Window,Qt::transparent );
    setPalette(qp);
    setDigitCount(m_timeFormat.length());
    setAttribute(Qt::WA_TranslucentBackground);
    setLineWidth(0);
    showTime();
}

void LcdClock::showTime()
{
    QTime time = QTime::currentTime();
    QString text = time.toString(m_timeFormat);
    if (m_blink1)
    {
        int lngt = text.length();
        if ((time.second() % 2) == 0)
        {
            text[lngt-m_blink1] = ' ';
            if (m_blink2)
                text[lngt-m_blink2] = ' ';
        }
    }
    display(text);
}
