#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "dclocksettings.h"

#include <QColorDialog>
#include <QColor>
#include <QMessageBox>
#include <QFontDatabase>

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    buildFontList();
    ui->chbBold->setEnabled(false);
    ui->chbItalic->setEnabled(false);
    loadSettings();
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::buildFontList()
{
    QFontDatabase database;

    foreach (QString family, database.families()) {
        ui->cbFont->addItem(family);
        }
}

void SettingsDialog::btnColorClicked()
{
    QColor newColor = QColorDialog::getColor(ui->labelColor->palette().color(QPalette::WindowText), 0);
    if (newColor.isValid())
        {
//            ui->label->setText(newColor.name());
        QPalette qp = ui->labelColor->palette();
        qp.setColor(QPalette::WindowText,newColor);
        ui->labelColor->setPalette(qp);
        }
}

void SettingsDialog::dumpSettings() const
{
    dclocksettings::getInstance().setColor(ui->labelColor->palette().color(QPalette::WindowText));
    dclocksettings::getInstance().setShowSeconds(ui->checkBox->isChecked());
    dclocksettings::getInstance().setTimeFormat(ui->cbTimeFormat->currentIndex());
    int w = ui->spinWidth->value();
    int h = ui->spinHeight->value();
    dclocksettings::getInstance().setSize(QSize(w,h));
    if (ui->cbFont->currentIndex() == 0)
        dclocksettings::getInstance().setLcd(true);
    else
        dclocksettings::getInstance().setLcd(false);
    dclocksettings::getInstance().setFont(m_font);
    dclocksettings::getInstance().setBlinking(ui->chbBlink->isChecked());
}

void SettingsDialog::loadSettings()
{
    QColor dColor = dclocksettings::getInstance().getColor();
    QPalette qp = ui->labelColor->palette();
    qp.setColor(QPalette::WindowText,dColor);
    ui->labelColor->setPalette(qp);
    ui->checkBox->setChecked(dclocksettings::getInstance().getShowSeconds());
    ui->cbTimeFormat->setCurrentIndex(dclocksettings::getInstance().getTimeFormat());
    QSize wSize = dclocksettings::getInstance().getSize();
    ui->spinWidth->setValue(wSize.width());
    ui->spinHeight->setValue(wSize.height());
    ui->chbBlink->setChecked(dclocksettings::getInstance().getBlinking());
    if (dclocksettings::getInstance().getLcd())
        ui->cbFont->setCurrentIndex(0);
    else
    {
        bool found = false;
        m_font = dclocksettings::getInstance().getFont();
        QString fnt_family(m_font.family());
        for (int i = 1; i < ui->cbFont->count(); i++)
        {
        if (ui->cbFont->itemText(i) == fnt_family)
            {
            ui->cbFont->setCurrentIndex(i);
            found = true;
            break;
        }
        }
        if (found)
        {
            ui->chbBold->setEnabled(true);
            ui->chbItalic->setEnabled(true);
            ui->chbBold->setChecked(m_font.bold());
            ui->chbItalic->setChecked(m_font.italic());
            ui->labelColor->setFont(m_font);
        }
        else
            ui->cbFont->setCurrentIndex(0);
    }
}

void SettingsDialog::showAbout()
{
    QMessageBox::about(this, tr("About DigiClock"),
                        tr("<b>DigiClock</b> 0.2.5<br>"
                        "Using <b>Qt 4.6.2</b><br>"
                        "Copyright (c) 2010 Avis<br>"
                        "<a href=\"mailto:avis@allnokia.ru\">avis@allnokia.ru</a><br><br>"
                        "Desktop widget, showing digital time"));
}

void SettingsDialog::showQtAbout()
{
    QMessageBox::aboutQt(this);
}

void SettingsDialog::fontChanged(int aIndex)
{
    if (ui->cbFont->currentIndex() == 0)
    {
        ui->chbBold->setEnabled(false);
        ui->chbItalic->setEnabled(false);
    }
    else
    {
        ui->chbBold->setEnabled(true);
        ui->chbItalic->setEnabled(true);
        m_font.setFamily(ui->cbFont->currentText());
        m_font.setBold(ui->chbBold->isChecked());
        m_font.setItalic(ui->chbItalic->isChecked());
        ui->labelColor->setFont(m_font);
    }
}
