#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QPushButton>

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

    void dumpSettings() const;

public slots:
    void btnColorClicked();
    void fontChanged(int aIndex);

private slots:
    void showAbout();
    void showQtAbout();

private:
    void loadSettings();
    void buildFontList();

private:
    Ui::SettingsDialog *ui;
    QFont m_font;
};

#endif // SETTINGSDIALOG_H
