#include <QtGui>
#include <QLocale>
#include <QtDBus/QtDBus>

#include "digitalclockwdg.h"
#include "settingsdialog.h"
#include "dclocksettings.h"
#include "lcdclock.h"
#include "fontclock.h"

DigitalClockWdg::DigitalClockWdg(QWidget *parent)
    : QWidget(parent)
{

    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(showTime()));
//    timer->start(10000);
    setWindowTitle(tr("Digital Clock"));
    resize(150, 60);
//    lcd = false;
    setAttribute(Qt::WA_TranslucentBackground);
//    this->setMouseTracking(false);

//    m_timeFormat = QString(" hh:mm:ss ap");
//    m_digitColor = QColor(Qt::green);
//    m_font.setFamily("Helvetica");
//    m_font.setBold(true);

    clk1 = new QWidget(this);

    m_timer = new QTimer(this);
    connect(m_timer, SIGNAL(timeout()), this, SLOT(showTime()));

//    showSettingsDialog();

    loadSettings();
    initClock();
}

void DigitalClockWdg::initClock()
{
    delete clk1;
    if (m_lcd)
    {
        clk1 = new LcdClock(m_digitColor, m_timeFormat, m_blinking1, m_blinking2, this);
        connect(this,SIGNAL(updateClock()),clk1,SLOT(showTime()));
        clk1->show();
//        m_lcd = false;
    }
    else
    {
        clk1 = new FontClock(m_digitColor, m_timeFormat, m_font, m_blinking1, m_blinking2, this);
        connect(this,SIGNAL(updateClock()),clk1,SLOT(showTime()));
        clk1->show();
//        lcd = true;
    }
}

void DigitalClockWdg::showTime()
{
    //TODO update clock
    emit updateClock();
//    QTime time = QTime::currentTime();
//    QString text;

//    QLocale cLoc (QLocale::English, QLocale::UnitedStates);
//    QString tf = cLoc.timeFormat();
//    text = time.toString(Qt::DefaultLocaleLongDate);
//    text = cLoc.toString(time, tf);

//    if (m_showSeconds)
//        text = time.toString("hh:mm:ss");
//        text = time.toString(m_timeFormat);
//    else
  //      text = time.toString("hhmmss");
  //      text = time.toString("hh:mm");
//    display(text);
}

void DigitalClockWdg::showSettingsDialog()
    {
    SettingsDialog dialog(0);
    if (dialog.exec() == QDialog::Accepted) {

        dialog.dumpSettings();
        loadSettings();
    }
}

void DigitalClockWdg::loadSettings()
{
    m_digitColor = dclocksettings::getInstance().getColor();
    bool showSeconds = dclocksettings::getInstance().getShowSeconds();
    int timeFormatIdx = dclocksettings::getInstance().getTimeFormat();
    m_size = dclocksettings::getInstance().getSize();
    bool blinking = dclocksettings::getInstance().getBlinking();
    m_blinking1 = 0;
    m_blinking2 = 0;

//    QString timeFormat;
    if (showSeconds)
        switch (timeFormatIdx)
        {
            case 1:     // 12 H (AM/PM)
                m_timeFormat = QString(" h:mm:ss ap");
                if (blinking)
                {
                    m_blinking1 = 6;
                    m_blinking2 = 9;
                }
                break;
            case 2:     // mmilitary
                m_timeFormat = QString("HHmmss");
                break;
            default:    // 24 H
                m_timeFormat = QString("HH:mm:ss");
                if (blinking)
                {
                    m_blinking1 = 3;
                    m_blinking2 = 6;
                }
            }
    else
        switch (timeFormatIdx)
        {
            case 1:     // 12 H (AM/PM)
                m_timeFormat = QString(" h:mm ap");
                if (blinking)
                {
                    m_blinking1 = 6;
                }
                break;
            case 2:     // mmilitary
                m_timeFormat = QString("HHmm");
                break;
            default:    // 24 H
                m_timeFormat = QString("HH:mm");
                if (blinking)
                {
                    m_blinking1 = 3;
                }

        }

//    setDigitCount(m_timeFormat.length());

    m_lcd = dclocksettings::getInstance().getLcd();
    m_font = dclocksettings::getInstance().getFont();

    m_timer->stop();
//    m_timer->start(m_timer_tick);
    m_timer->start(1000);
/*    QPalette qp;
    qp.setColor(QPalette::WindowText,m_digitColor );
    qp.setColor(QPalette::Window,Qt::transparent );
    setPalette(qp);*/
    int x = geometry().x();
    int y = geometry().y();
    setGeometry(x,y,m_size.width(),m_size.height());
    initClock();
    //resize(m_size);
}

void DigitalClockWdg::homeScreenChanged(bool isOnCurrentHomescreen)
{
    if (isOnCurrentHomescreen)
    {
        if (!m_timer->isActive())
//            m_timer->start(m_timer_tick);
            m_timer->start(1000);
        showTime();
    }
    else
        m_timer->stop();
}


void DigitalClockWdg::mouseReleaseEvent ( QMouseEvent * e )
{
    Q_UNUSED(e);
    //test Dialogs
    if ((m_mouseClick) && (e->pos() == m_lastPoint) )
    {
        showClock();
    }
}

void DigitalClockWdg::mousePressEvent ( QMouseEvent * e )
{
//    Q_UNUSED(e);
    m_lastPoint = e->pos();
    m_mouseClick = true;
}
/*
void DigitalClockWdg::mouseMoveEvent ( QMouseEvent * e )
{
    Q_UNUSED(e);
    m_mouseClick = false;
}
*/
void DigitalClockWdg::showClock()
{
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusInterface dbus_iface("com.nokia.HildonDesktop.AppMgr", "/com/nokia/HildonDesktop/AppMgr",
                          "com.nokia.HildonDesktop.AppMgr", bus);
    dbus_iface.call("LaunchApplication","worldclock");
}
