#ifndef DCLOCKSETTINGS_H
#define DCLOCKSETTINGS_H
#include <QSize>
#include <QColor>
#include <QFont>

class dclocksettings
{
public:
    static dclocksettings& getInstance()
    {
        static dclocksettings instance; // Guaranteed to be destroyed.
        // Instantiated on first use.
        return instance;
    }

    //get/set widget size;
    QSize getSize() const;
    void setSize(const QSize &aSize) const;
    //get/set color of digits
    QColor getColor() const;
    void setColor(const QColor &aColor) const;
    //get/set show seconds flag
    bool getShowSeconds() const;
    void setShowSeconds(const bool &aShow) const;
    //get/set time format
    int getTimeFormat() const;
    void setTimeFormat(const int &aFormatIdx) const;
    //get/set LCD
    bool getLcd() const;
    void setLcd(const bool &aLcd) const;
    //get/set font
    QFont getFont() const;
    void setFont(const QFont &aFont) const;

private:
    dclocksettings() {}
    dclocksettings(dclocksettings const&);              // Don't Implement
    void operator=(dclocksettings const&); // Don't implement
};

#endif // DCLOCKSETTINGS_H
