#include <QtGui>
#include <QLocale>

#include "digitalclockwdg.h"
#include "settingsdialog.h"
#include "dclocksettings.h"
#include "lcdclock.h"
#include "fontclock.h"

DigitalClockWdg::DigitalClockWdg(QWidget *parent)
    : QWidget(parent)
{

    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(showTime()));
//    timer->start(10000);
    setWindowTitle(tr("Digital Clock"));
    resize(150, 60);
//    lcd = false;
    setAttribute(Qt::WA_TranslucentBackground);

//    m_timeFormat = QString(" hh:mm:ss ap");
//    m_digitColor = QColor(Qt::green);
//    m_font.setFamily("Helvetica");
//    m_font.setBold(true);

    clk1 = new QWidget(this);

    m_timer = new QTimer(this);
    connect(m_timer, SIGNAL(timeout()), this, SLOT(showTime()));

//    showSettingsDialog();

    loadSettings();
    initClock();
}

void DigitalClockWdg::initClock()
{
    delete clk1;
    if (m_lcd)
    {
        clk1 = new LcdClock(m_digitColor, m_timeFormat, this);
        connect(this,SIGNAL(updateClock()),clk1,SLOT(showTime()));
        clk1->show();
//        m_lcd = false;
    }
    else
    {
        clk1 = new FontClock(m_digitColor, m_timeFormat, m_font, this);
        connect(this,SIGNAL(updateClock()),clk1,SLOT(showTime()));
        clk1->show();
//        lcd = true;
    }
}

void DigitalClockWdg::showTime()
{
    //TODO update clock
    emit updateClock();
//    QTime time = QTime::currentTime();
//    QString text;

//    QLocale cLoc (QLocale::English, QLocale::UnitedStates);
//    QString tf = cLoc.timeFormat();
//    text = time.toString(Qt::DefaultLocaleLongDate);
//    text = cLoc.toString(time, tf);

//    if (m_showSeconds)
//        text = time.toString("hh:mm:ss");
//        text = time.toString(m_timeFormat);
//    else
  //      text = time.toString("hhmmss");
  //      text = time.toString("hh:mm");
//    display(text);
}

void DigitalClockWdg::showSettingsDialog()
    {
    SettingsDialog dialog(0);
    if (dialog.exec() == QDialog::Accepted) {

        dialog.dumpSettings();
        loadSettings();
    }
}

void DigitalClockWdg::loadSettings()
{
    m_digitColor = dclocksettings::getInstance().getColor();
    bool showSeconds = dclocksettings::getInstance().getShowSeconds();
    int timeFormatIdx = dclocksettings::getInstance().getTimeFormat();
    m_size = dclocksettings::getInstance().getSize();

//    QString timeFormat;
    if (showSeconds)
        switch (timeFormatIdx)
        {
            case 1:     // 12 H (AM/PM)
                m_timeFormat = QString(" h:mm:ss ap");
                break;
            case 2:     // mmilitary
                m_timeFormat = QString("HHmmss");
                break;
            default:    // 24 H
                m_timeFormat = QString("HH:mm:ss");
            }
    else
        switch (timeFormatIdx)
        {
            case 1:     // 12 H (AM/PM)
                m_timeFormat = QString(" h:mm ap");
                break;
            case 2:     // mmilitary
                m_timeFormat = QString("HHmm");
                break;
            default:    // 24 H
                m_timeFormat = QString("HH:mm");
        }

//    setDigitCount(m_timeFormat.length());

    m_lcd = dclocksettings::getInstance().getLcd();
    m_font = dclocksettings::getInstance().getFont();

    m_timer->stop();
//    m_timer->start(m_timer_tick);
    m_timer->start(1000);
/*    QPalette qp;
    qp.setColor(QPalette::WindowText,m_digitColor );
    qp.setColor(QPalette::Window,Qt::transparent );
    setPalette(qp);*/
    int x = geometry().x();
    int y = geometry().y();
    setGeometry(x,y,m_size.width(),m_size.height());
    initClock();
    //resize(m_size);
}

void DigitalClockWdg::homeScreenChanged(bool isOnCurrentHomescreen)
{
    if (isOnCurrentHomescreen)
    {
        if (!m_timer->isActive())
//            m_timer->start(m_timer_tick);
            m_timer->start(1000);
        showTime();
    }
    else
        m_timer->stop();
}

