#include <QtGui>

#include "lcdclock.h"

LcdClock::LcdClock(QColor &aColor, QString &aFormat, QWidget *parent)
    : QLCDNumber(parent),  m_timeFormat(aFormat)
{
    setSegmentStyle(Filled);
    QSize aa = parent->size();
    resize(aa);
    QPalette qp;
    qp.setColor(QPalette::WindowText,aColor );
    qp.setColor(QPalette::Window,Qt::transparent );
    setPalette(qp);
    setDigitCount(m_timeFormat.length());
    setAttribute(Qt::WA_TranslucentBackground);
    setLineWidth(0);
    showTime();
}

void LcdClock::showTime()
{
    QTime time = QTime::currentTime();
    QString text = time.toString(m_timeFormat);
//    if ((time.second() % 2) == 0)
  //      text[2] = ' ';
    display(text);
}
