#!/usr/bin/env python

import re
import csv
import pprint


_nameRe = re.compile("name", re.IGNORECASE)
_phoneRe = re.compile("phone", re.IGNORECASE)
_mobileRe = re.compile("mobile", re.IGNORECASE)

def read_csv(csvPath):
	csvReader = iter(csv.reader(open(csvPath, "rU")))

	header = csvReader.next()
	nameColumn, phoneColumns = _guess_columns(header)

	yieldCount = 0
	for row in csvReader:
		a = dict((ch, cr) for ch, cr in zip(header, row))
		pprint.pprint(a)

		b = {
			header[nameColumn]: row[nameColumn],
			"numbers": dict(
				(header[phoneColumn[1]], row[phoneColumn[1]]) for phoneColumn in phoneColumns
			)
		}
		pprint.pprint(b)
		print

def _guess_columns(row):
	names = []
	phones = []
	for i, item in enumerate(row):
		if _nameRe.search(item) is not None:
			names.append((item, i))
		elif _phoneRe.search(item) is not None:
			phones.append((item, i))
		elif _mobileRe.search(item) is not None:
			phones.append((item, i))
	if len(names) == 0:
		names.append(("Name", 0))
	if len(phones) == 0:
		phones.append(("Phone", 1))

	return names[0][1], phones

read_csv("/home/epage/.dialcentral/contacts/EvoIsEvil.csv")
