GtkWidget *win;
struct stat buf;
DIR *dir;
struct dirent *dirpointer;
GtkWidget *dialog=NULL;
gchar *last_app_standing;
gchar *playlist_dir;

char *mp3_play_status;
int mp3_default;

char *sh_exec_status;
int sh_exec_default;

char *picviewer_status;
int picviewer;

char *mode_status;
int fast_mode;

int center_label;
int toolbar_on_top;
int ff_mode;
int bookmarkview;

#ifndef DESKYPPLET_H
#define DESKYPPLET_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define APPLET_X_SIZE 450
#define APPLET_Y_SIZE 300
#define TOOLBAR_Y_SIZE 3

#define MIN_X_SIZE 140
#define MAX_X_SIZE 800
#define MIN_Y_SIZE 140
#define MAX_Y_SIZE 420

#define SETTINGS_PATH	".deskypplet"
#define PREFS_FILE	"deskypplet.conf"

#define DEFAULT_COLOR		"#ffff00"
#define DEFAULT_FONT_COLOR	"#000000"
#define DEFAULT_FONT		"Sans 12"
#define DEFAULT_BG_ALPHA	50



typedef struct _DeskYppletPlugin DeskYppletPlugin;
typedef struct _DeskYppletPluginClass DeskYppletPluginClass;

#define DESKYPPLET_TYPE_HOME_PLUGIN   (deskypplet_home_plugin_get_type ())

#define DESKYPPLET_HOME_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN, DeskYppletHomePlugin))

#define DESKYPPLET_HOME_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN,  DeskYppletPluginClass))

#define DESKYPPLET_IS_HOME_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN))
 
#define DESKYPPLET_IS_HOME_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN))

#define DESKYPPLET_HOME_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
			                        DESKYPPLET_TYPE_HOME_PLUGIN,  DeskYppletHomePluginClass))
 
struct _DeskYppletPlugin
{
	    HDHomePluginItem hitem;
};
 
struct _DeskYppletPluginClass
{
	    HDHomePluginItemClass parent_class;
};
 
GType deskypplet_plugin_get_type(void);

HD_DEFINE_PLUGIN_MODULE (DeskYppletPlugin, deskypplet_plugin, HD_TYPE_HOME_PLUGIN_ITEM);

static void deskypplet_plugin_realize (GtkWidget *widget);
static gboolean deskypplet_plugin_expose_event(GtkWidget *widget, GdkEventExpose *event);

typedef struct
{
	DeskYppletPlugin *parent;
	
    GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *vbox_fb;	
	GtkWidget *hbox_toolb;
	GtkWidget *top;
	GtkScrolledWindow *scrolledwindow_fb;
	GtkWidget *table;

	GtkWidget *path_label;
	GtkWidget *vscroll;
	GtkWidget *hscroll;
	GtkWidget *label_evbox;
	GtkWidget *folder_up_evbox;
	GtkWidget *folder_up_image;
	GtkWidget *folder_home_image;
	GtkWidget *folder_home_evbox;
	GtkWidget *folder_home_togglebox;
			
	GtkTextBuffer *buffer;
	
	GdkColor color;
	GdkColor fontcolor;
	
	gchar *fontname;
	
	gchar *prefs_dir;
	gchar *conf_file;
    gchar *work_dir;
	gchar *home_dir;
	
	gfloat bg_alpha;

    gchar *bookmarks_name_size;
	gchar *files_name_size;
	gchar *title_font_size;
	
	gint applet_x_size;
	gint applet_y_size;
	gint *locked;
	gint icon_x_size;
	gint icon_y_size;
	gint icon_label_x_size;
	gint icon_label_y_size;
	gint title_height;
	gint title_button_size;
	 
} YNCtx;

/*adjusting width and height not to exceed max size allowed*/
void adjust_settings(YNCtx *app);

/*read preferences from config file and load into object*/
void load_applet_prefs(YNCtx *app);

/*callback to get background color selection*/
void select_bg_color(GObject *o, YNCtx *app);

/*callback to get text font selection*/
void select_font(GObject *o, YNCtx *app);

/*callback to get font color selection*/
void select_font_color(GObject *o, YNCtx *app);

/*function to apply color and alpha value to widget using cairo*/
void set_cairo_transparency(GdkDrawable *drawable, GdkEventExpose *event, GdkColor color, gfloat alpha);

/*callback to show settings dialog (settings button) --not used in fremantle*/
gboolean configure_applet_button(GObject *o,GdkEventButton *event,YNCtx *app);

/*callback to show settings dialog in Desktop editing mode (fremantle)*/
gboolean configure_applet(GtkWidget *o,YNCtx *app);

/*create desktop widget applet and build UI*/
void mkplugin_create_home_applet(YNCtx *app);
void build_ui(void);
void create_table (YNCtx *app);
static gboolean handle_expose (GtkWidget *widget, GdkEventExpose *event);
static gboolean handle_expose_scrollbar (GtkWidget *widget, GdkEventExpose *event);
GdkPixbuf *get_pixbuf_folder (gchar *fullpath);
GdkPixbuf *get_pixbuf_file (gchar *fullpath);

/*help func*/
int myComparisonFunction(const void *x, const void *y);
gchar *g_get_free_space ( gchar * dev_path);
gchar *g_get_capacity ( gchar * dev_path);

/*----*/
void menu (void);
void menu_folders (gchar *fullpath);
void menu_files (gchar *fullpath);

/*mode switches*/
void toggle_mp3_play (void);
void toggle_picviewer (void);
void toggle_exec_sh (void);
void toggle_mode (void);
void toggle_bookmark_view (GObject *o,GdkEventButton *event,YNCtx *app);

/*handle rotation*/
static gboolean is_portrait ();
void on_orientation_changed(GdkScreen *screen,YNCtx *app);

/*navigation*/
void change_folder (gchar *fullpath);
void change_folder2 (gpointer button,gchar *fullpath);
void go_folder_up (GObject *o,GdkEventButton *event,YNCtx *app);

/*action*/
void icon_tap (GObject *o,GdkEventButton *event,gchar *fullpath);
void icon_tap_advanced (GObject *o,GdkEventButton *event,gchar *fullpath);
void handle_mime (gchar *fullpath);
void bookmark_tapped (GObject *o,GdkEventButton *event,gchar *fullpath);/*gpointer button*/
void custom_com (gpointer button,gchar *com_do);
void open_file (gpointer button,gchar *fullpath);

/*void term_her (void);*/
void check_config (void);

/*additional features*/
void pic_view(GdkPixbuf *pixbuf);
void end_picview (void);
static gboolean is_mp3_folder (gchar *fullpath);
void play_folder (gchar *fullpath);
void book_this (GObject *o,GdkEventButton *event);
void call_help (void);
void show_bookmarks (YNCtx *app);

/*widget style to unset sapwood engine for scrollbar.
RGBA colormap has conflict with default theme's PNGs*/
gchar *scroll_style="style \"my-style\" \
{ \
	bg[NORMAL] = \"#FAFAFA\" \
	bg[ACTIVE] = \"#202020\" \
        GtkRange::stepper_size = 50 \
        GtkRange::stepper_spacing = 0 \
        GtkRange::trough_border = 0 \
        GtkRange::slider_width = 25 \
        GtkRange::draw_trough_under_steppers = 0 \
        GtkRange::draw_trough = 1 \
        GtkRange::arrow_displacement_x = 0 \
        GtkRange::arrow_displacement_y = 0 \
        GtkRange::autodimmed_steppers = 0 \
        GtkScrollbar::min-slider-length = 32 \
	GtkScrollbar::scrollbar-spacing = 0 \
        GtkRange::activate-slider = 1 \
	engine \"\" { } \
} \
class \"GtkScrollbar\" style \"my-style\"";

G_END_DECLS

#endif
