#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QFile>
#include <QMessageBox>
#include <QTextStream>
#include <QDesktopWidget>
#include <QFileDialog>
#include <QInputDialog>
#include <QLabel>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)


{
    system("mkdir /home/user/MyDocs/.images/desktop+ & mv /home/*.png /home/user/MyDocs/.images/desktop+/");

    QString helpText;

    helpText.append(tr("<h3>Erste Schritte:") +"</h3>");
    helpText.append(tr("(1) Mindestens 'Matan's modified-hildon-desktop' muss installiert sein um zustzliche Desktops zu aktivieren.")+"<br/>");
    helpText.append(tr("<p>(2) Die Hintergrnde mssen unter <b>/home/user/MyDocs/.images/desktop+/ liegen<br/>und 1.png - 9.png heien.</b>"));

    QMessageBox::about(this, tr("Desktop+"),
                       helpText);

    ui->setupUi(this);
    connect(ui->actionHelp, SIGNAL(triggered()), this, SLOT(showHelp()));
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
    connect(ui->actionInstall, SIGNAL(triggered()), this, SLOT(showInstall()));
    connect(ui->actionTest, SIGNAL(triggered()), this, SLOT(showTest()));


}

MainWindow::~MainWindow()
{

    delete ui;
}

void MainWindow::showHelp()
{
    QString helpText;

    helpText.append("<h3>Desktop+ "+tr("Hilfe") +"</h3>");
    helpText.append("<p>"+ tr("...vereinfacht das anlegen zustzlicher Desktops")+"<br/>");
    helpText.append(tr("'Matan's modified-hildon-desktop' muss installiert sein um zustzliche Desktops zu aktivieren.")+"<br/>");
    helpText.append(tr("<h3>Die Hintergrnde mssen unter /home/user/MyDocs/.images/desktop+/ liegen und 1.png - 9.png heien.</h3>")+"<br/>");
    QMessageBox::about(this, tr("Hilfe"),
                       helpText);
}

void MainWindow::showAbout()
{
    QString about;
    about.append("<h3>Desktop+</h3>");
    about.append(tr("Entwickelt in Qt %1<br/>").arg(QString(QT_VERSION_STR)));
    about.append(tr("Copyright") + " 2010 - &lt;NightShift79@highspeed3.de&gt;<br/><br/>");

    QMessageBox::about(this, tr("ber Desktop+"),
                       about);
}

void MainWindow::showInstall()
{
    QString mhd;
    mhd.append("<p>"+ tr("<br/><h3>Ein modifizierter hildon-desktop wird bentigt!</h3>")+"");
    mhd.append("<p>"+ tr("ber den untenstehenden Link kann die neuste, inoffizielle version von MohammadAGs hildon-desktop runtergeladen werden.")+"<br/>"+("Dieser mu mittels 'dpgk -i' im Terminal installiert werden.")+"<br/>");
    mhd.append("Diese Version beinhaltet neben einigen Verbesserungen auch alle features on Matans modified-hildon-desktop.");
    mhd.append(tr("<h3><a href=http://mohammadag.xceleo.org/public/maemo/debfiles/matan/hildon-desktop_2.2.138-1+0m5_armel.deb>modified-hildon-desktop</a></h3></p>"));

        QMessageBox::about(this, tr("MohammadAG hildon-desktop (incl. Matans mhd)"),
                           mhd);
    }

void MainWindow::showTest()
{
    system("cp /home/user/MyDocs/.images/desktop+/01.png /home/user/.backgrounds/background-1.png && cp /home/user/MyDocs/.images/desktop+/02.png /home/user/.backgrounds/background-2.png && cp /home/user/MyDocs/.images/desktop+/03.png /home/user/.backgrounds/background-3.png && cp /home/user/MyDocs/.images/desktop+/04.png /home/user/.backgrounds/background-4.png && cp /home/user/MyDocs/.images/desktop+/05.png /home/user/.backgrounds/background-5.png && cp /home/user/MyDocs/.images/desktop+/06.png /home/user/.backgrounds/background-6.png && cp /home/user/MyDocs/.images/desktop+/07.png /home/user/.backgrounds/background-7.png && cp /home/user/MyDocs/.images/desktop+/08.png /home/user/.backgrounds/background-8.png && cp /home/user/MyDocs/.images/desktop+/09.png /home/user/.backgrounds/background-9.png");

    }



void MainWindow::on_pushButton_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 4 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_2_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 5 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}


void MainWindow::on_pushButton_6_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 6 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5,6]");

    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_5_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 7 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5,6,7]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_4_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 8 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5,6,7,8]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_13_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 9 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5,6,7,8,9]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}


void MainWindow::on_pushButton_11_clicked()
{

        QString question;
        question.append("Sollen die Hintergrnde gesetzt werden?<br/><br/>");
        question.append("Sie werden aus '../.images/desktop+' nach '../.backgrounds/' kopiert.");

        QMessageBox::StandardButton reply;
        reply = QMessageBox::question(this, tr("Hintergrund fr Desktops setzen:"),
                                        question,
                                        QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
        if (reply == QMessageBox::Yes)
            system("cp /home/user/MyDocs/.images/desktop+/1.png /home/user/.backgrounds/background-1.png && cp /home/user/MyDocs/.images/desktop+/2.png /home/user/.backgrounds/background-2.png && cp /home/user/MyDocs/.images/desktop+/3.png /home/user/.backgrounds/background-3.png && cp /home/user/MyDocs/.images/desktop+/4.png /home/user/.backgrounds/background-4.png && cp /home/user/MyDocs/.images/desktop+/5.png /home/user/.backgrounds/background-5.png && cp /home/user/MyDocs/.images/desktop+/6.png /home/user/.backgrounds/background-6.png && cp /home/user/MyDocs/.images/desktop+/7.png /home/user/.backgrounds/background-7.png && cp /home/user/MyDocs/.images/desktop+/8.png /home/user/.backgrounds/background-8.png && cp /home/user/MyDocs/.images/desktop+/9.png /home/user/.backgrounds/background-9.png");

        else if (reply == QMessageBox::No)
            ;

        else
            ;

}

void MainWindow::on_pushButton_10_clicked()
{
    QString question;
    question.append("<p><h2>Soll der Inhalt von '/home/user/.backgrounds/' gelscht werden?</h2></p>");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Cache lschen:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("rm /home/user/.backgrounds/*.*");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}
