#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QFile>
#include <QMessageBox>
#include <QTextStream>
#include <QDesktopWidget>
#include <QFileDialog>
#include <QInputDialog>
#include <QLabel>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)


{

    ui->setupUi(this);
    connect(ui->actionHelp, SIGNAL(triggered()), this, SLOT(showHelp()));
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
    connect(ui->actionInstall, SIGNAL(triggered()), this, SLOT(showInstall()));
    connect(ui->actionInstall2, SIGNAL(triggered()), this, SLOT(showInstall2()));

}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::showHelp()
{
    QString helpText;

    helpText.append("<h2>Desktop+ "+tr("Hilfe") +"</h2>");
    helpText.append("<p>"+ tr("vereinfacht das anlegen zustzlicher Desktops")+"<br/>");
    helpText.append(tr("Der 'modified-hildon-desktop' muss installiert sein um zustzliche Desktops zu aktivieren.")+"<br/>");
    helpText.append(tr("<h2>Die Hintergrnde mssen unter /home/user/MyDocs/.images/desktop+/ liegen und 1.png - 9.png heien.</h2>")+"<br/>");
    QMessageBox::about(this, tr("Hilfe"),
                       helpText);
}

void MainWindow::showAbout()
{
    QString about;
    about.append("<h2>Desktop+</h2>");
    about.append(tr("Entwickelt in Qt %1<br/>").arg(QString(QT_VERSION_STR)));
    about.append(tr("Copyright") + " 2010 - &lt;NightShift79@meego.de&gt;<br/><br/>");

    QMessageBox::about(this, tr("ber Desktop+"),
                       about);
}

void MainWindow::showInstall()
{
    QString mhd;
    mhd.append("ber den Link installieren:");
        mhd.append(tr("<h1><a href=http://my.arava.co.il/~matan/770/n900/m-h-d.install>modified-hildon-desktop</a><br/></h1></p>"));

        QMessageBox::about(this, tr("modified-hildon-desktop"),
                           mhd);
    }

void MainWindow::showInstall2()
{
    QString mhd;
        mhd.append("<h2>Achtung: Nur fr PR1.2</h2>");
        mhd.append("<p>ber den Link downloaden und manuell installieren.<br/>'dpgk -i hildon-home_0.3.66-2+0m5_armel.deb' im XTerm.");
        mhd.append(tr("<h1><a href=http://my.arava.co.il/~matan/770/n900/hildon-home_0.3.66-2+0m5_armel.deb>modified-hildon-home</a></h1>"));

        QMessageBox::about(this, tr("modified-hildon-home"),
                           mhd);
    }

void MainWindow::on_pushButton_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 4 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_2_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 5 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
        system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}


void MainWindow::on_pushButton_6_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 6 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5,6]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_5_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 7 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5,6,7]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_4_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 8 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5,6,7,8]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_13_clicked()
{
    QString question;
    question.append("Sind Sie sicher, dass Sie 9 Desktops aktivieren mchten?");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Desktop+"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/active -t list --list-type int [1,2,3,4,5,6,7,8,9]");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}

void MainWindow::on_pushButton_11_clicked()
{

        QString question;
        question.append("<p>Haben Sie modified-hildon-home installiert?</p>");
        question.append("Wenn 'Ja', wird der Hintergrund ber das gconftool eingestellt.<br/>");
        question.append("Wenn 'Nein' wird der Hintergrund nach '../.backgrounds/' kopiert.");

        QMessageBox::StandardButton reply;
        reply = QMessageBox::question(this, tr("Hintergrund fr Desktop 5 setzen:"),
                                        question,
                                        QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
        if (reply == QMessageBox::Yes)
                        system("gconftool-2 -s /apps/osso/hildon-desktop/views/5/bg-image -t string /home/user/MyDocs/.images/desktop+/5.png");
        else if (reply == QMessageBox::No)
            system("cp /home/user/MyDocs/.images/desktop+/5.png /home/user/.backgrounds/background-5.png");
        else
            ;

}

void MainWindow::on_pushButton_12_clicked()
{
    QString question;
    question.append("<p>Haben Sie modified-hildon-home installiert?</p>");
    question.append("Wenn 'Ja', wird der Hintergrund ber das gconftool eingestellt.<br/>");
    question.append("Wenn 'Nein' wird der Hintergrund nach '../.backgrounds/' kopiert.");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Hintergrund fr Desktop 6 setzen:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/6/bg-image -t string /home/user/MyDocs/.images/desktop+/6.png");
    else if (reply == QMessageBox::No)
        system("cp /home/user/MyDocs/.images/desktop+/6.png /home/user/.backgrounds/background-6.png");
    else
        ;

}
void MainWindow::on_pushButton_7_clicked()
{
    QString question;
    question.append("<p>Haben Sie modified-hildon-home installiert?</p>");
    question.append("Wenn 'Ja', wird der Hintergrund ber das gconftool eingestellt.<br/>");
    question.append("Wenn 'Nein' wird der Hintergrund nach '../.backgrounds/' kopiert.");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Hintergrund fr Desktop 7 setzen:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/7/bg-image -t string /home/user/MyDocs/.images/desktop+/7.png");
    else if (reply == QMessageBox::No)
        system("cp /home/user/MyDocs/.images/desktop+/7.png /home/user/.backgrounds/background-7.png");
    else
        ;
}

void MainWindow::on_pushButton_8_clicked()
{
    QString question;
    question.append("<p>Haben Sie modified-hildon-home installiert?</p>");
    question.append("Wenn 'Ja', wird der Hintergrund ber das gconftool eingestellt.<br/>");
    question.append("Wenn 'Nein' wird der Hintergrund nach '../.backgrounds/' kopiert.");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Hintergrund fr Desktop 8 setzen:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/8/bg-image -t string /home/user/MyDocs/.images/desktop+/8.png");
    else if (reply == QMessageBox::No)
        system("cp /home/user/MyDocs/.images/desktop+/8.png /home/user/.backgrounds/background-8.png");
    else
        ;
}

void MainWindow::on_pushButton_9_clicked()
{
    QString question;
    question.append("<p>Haben Sie modified-hildon-home installiert?</p>");
    question.append("Wenn 'Ja', wird der Hintergrund ber das gconftool eingestellt.<br/>");
    question.append("Wenn 'Nein' wird der Hintergrund nach '../.backgrounds/' kopiert.");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Hintergrund fr Desktop 9 setzen:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("gconftool-2 -s /apps/osso/hildon-desktop/views/9/bg-image -t string /home/user/MyDocs/.images/desktop+/9.png");
    else if (reply == QMessageBox::No)
        system("cp /home/user/MyDocs/.images/desktop+/9.png /home/user/.backgrounds/background-9.png");
    else
        ;
}

void MainWindow::on_pushButton_10_clicked()
{
    QString question;
    question.append("<p><h2>Soll der Inhalt von '/home/user/.backgrounds/' gelscht werden?</h2></p>");

    QMessageBox::StandardButton reply;
    reply = QMessageBox::question(this, tr("Cache lschen:"),
                                    question,
                                    QMessageBox::Yes | QMessageBox::No | QMessageBox::Cancel);
    if (reply == QMessageBox::Yes)
                    system("rm /home/user/.backgrounds/*.*");
    else if (reply == QMessageBox::No)
        ;
    else
        ;
}
