#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "desktop-cmd-exec.h"
#include <hildon/hildon.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libintl.h>

#define HOME_DIR g_get_home_dir()

#define _(String) dgettext("hildon-libs", String)

#define DESKTOP_CMD_EXEC_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, DESKTOP_CMD_EXEC_TYPE, DesktopCmdExecPrivate))

void desktop_cmd_exec_write_settings (DesktopCmdExec *self);
gboolean desktop_cmd_exec_update_content (DesktopCmdExec *self);

struct _DesktopCmdExecPrivate
{

	GtkWidget *homeWidget;
	GtkWidget *event;
	GtkWidget *contents;
	
	GtkWidget *cmdTitle_lb;
	GtkWidget *cmdResult_lb;
	
	gboolean isPressed;

	gchar * c1_title;
	gchar * c1_command;
	
	gboolean c1_updOnClick;
	gboolean c1_updOnDesktop;
	
	
	guint eventID;
};

HD_DEFINE_PLUGIN_MODULE (DesktopCmdExec, desktop_cmd_exec, HD_TYPE_HOME_PLUGIN_ITEM);


void desktop_cmd_exec_read_settings ( DesktopCmdExec *self )
{
// 	g_warning("desktop_cmd_exec_read_settings ");
	gchar *filename;
	gboolean fileExists;
	GKeyFile *keyFile;

	keyFile = g_key_file_new();
	filename = g_strconcat (HOME_DIR, "/.desktop_cmd_exec", NULL);
	fileExists = g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);

	if (fileExists) {
		GError *error=NULL;

		self->priv->c1_command = g_key_file_get_string (keyFile, "config", "c1_command", &error);
		if (error) {
			self->priv->c1_command = NULL;
			g_error_free (error);
			error = NULL;
		}

		self->priv->c1_title = g_key_file_get_string (keyFile, "config", "c1_title", &error);
		if (error) {
			self->priv->c1_title = NULL;
			g_error_free (error);
			error = NULL;
		}

		self->priv->c1_updOnClick = g_key_file_get_boolean (keyFile, "config", "c1_updOnClick", &error);
		if (error) {
			self->priv->c1_updOnClick = TRUE;
			g_error_free (error);
			error = NULL;
		}

		self->priv->c1_updOnDesktop = g_key_file_get_boolean (keyFile, "config", "c1_updOnDesktop", &error);
		if (error) {
			self->priv->c1_updOnDesktop = TRUE;
			g_error_free (error);
			error = NULL;
		}

	} else {
		
		self->priv->c1_command = NULL;
		self->priv->c1_title = NULL;
		self->priv->c1_updOnClick = TRUE;
		self->priv->c1_updOnDesktop = TRUE;
		
		desktop_cmd_exec_write_settings(self);
	}

	g_key_file_free (keyFile);
	g_free (filename);
}

void desktop_cmd_exec_write_settings (DesktopCmdExec *self)
{
// 	g_warning ("desktop_cmd_exec_write_settings");
	GKeyFile *keyFile;
	gchar *fileData;
	FILE *iniFile;
	gsize size;
	gchar *filename;
	
	keyFile = g_key_file_new();
	
	if(!self->priv->c1_command)
		self->priv->c1_command = "cat /proc/uptime | awk '{print $1}'";
	g_key_file_set_string (keyFile, "config", "c1_command", self->priv->c1_command);

	if(!self->priv->c1_title)
		self->priv->c1_title = "Uptime: ";
	g_key_file_set_string (keyFile, "config", "c1_title", self->priv->c1_title);

	g_key_file_set_boolean (keyFile, "config", "c1_updOnClick", self->priv->c1_updOnClick);
	g_key_file_set_boolean (keyFile, "config", "c1_updOnDesktop", self->priv->c1_updOnDesktop);
	
	filename = g_strconcat (HOME_DIR, "/.desktop_cmd_exec", NULL);
	fileData = g_key_file_to_data (keyFile, &size, NULL);
	iniFile = fopen (filename, "w");
	fputs (fileData, iniFile);
	fclose (iniFile);
	g_key_file_free (keyFile);
	g_free (fileData);
	g_free (filename);
}

void desktop_cmd_exec_button_press (GtkWidget *widget, GdkEventButton *event, DesktopCmdExec *self)
{
// 	g_warning ("desktop_cmd_exec_button_press");
	if (self->priv->c1_updOnClick) {
		self->priv->isPressed = TRUE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

void desktop_cmd_exec_button_release (GtkWidget *widget, GdkEventButton *event, DesktopCmdExec *self)
{
// 	g_warning ("desktop_cmd_exec_button_release");
	if (self->priv->c1_updOnClick) {
		self->priv->isPressed = FALSE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
		desktop_cmd_exec_update_content(self);
	}
}

void desktop_cmd_exec_leave_event (GtkWidget *widget, GdkEventCrossing *event, DesktopCmdExec *self)
{
// 	g_warning ("desktop_cmd_exec_leave_event");
	if (self->priv->c1_updOnClick) {
		self->priv->isPressed = FALSE;
		gtk_widget_queue_draw (GTK_WIDGET (self));
	}
}

void desktop_cmd_exec_content_create (DesktopCmdExec *self)
{
// 	g_warning ("desktop_cmd_exec_content_create");
	self->priv->contents = gtk_event_box_new ();
	gtk_event_box_set_visible_window (GTK_EVENT_BOX (self->priv->contents), FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (self->priv->contents), 0);
// 	GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));

	self->priv->cmdTitle_lb = gtk_label_new ("title:");
	self->priv->cmdResult_lb = gtk_label_new ("result");
	
	GtkWidget *box = gtk_hbox_new (FALSE, 0);
	
	gtk_box_pack_start (GTK_BOX (box), self->priv->cmdTitle_lb, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (box), self->priv->cmdResult_lb, TRUE, TRUE, 0);
	
	hildon_helper_set_logical_color (self->priv->cmdResult_lb, GTK_RC_FG, GTK_STATE_NORMAL, "ActiveTextColor");

	gtk_misc_set_alignment (GTK_MISC (self->priv->cmdTitle_lb), 0, 1);
	gtk_misc_set_alignment (GTK_MISC (self->priv->cmdResult_lb), 1, 1);

	gtk_misc_set_padding (GTK_MISC (self->priv->cmdTitle_lb), HILDON_MARGIN_DEFAULT, HILDON_MARGIN_HALF);
	gtk_misc_set_padding (GTK_MISC (self->priv->cmdResult_lb), HILDON_MARGIN_DEFAULT, HILDON_MARGIN_HALF);

	gtk_container_add (GTK_CONTAINER (self->priv->contents), box);
	gtk_box_pack_start (GTK_BOX (self->priv->homeWidget), self->priv->contents, FALSE, FALSE, 0);

	//widget drawing signal connections
	g_signal_connect (self->priv->contents, "button-release-event", G_CALLBACK (desktop_cmd_exec_button_release), self);
	g_signal_connect (self->priv->contents, "button-press-event", G_CALLBACK (desktop_cmd_exec_button_press), self);
	g_signal_connect (self->priv->contents, "leave-notify-event", G_CALLBACK (desktop_cmd_exec_leave_event), self);
	
	gtk_widget_show_all (self->priv->homeWidget);
	gtk_widget_show (self->priv->cmdTitle_lb);
}

gboolean desktop_cmd_exec_update_content (DesktopCmdExec *self)
{
// 	g_warning ("desktop_cmd_exec_update_content");
	FILE *fp;
	gchar line[256];
	gchar *result;
	
	gboolean found = FALSE;

	gtk_label_set_text (GTK_LABEL (self->priv->cmdTitle_lb), self->priv->c1_title);

	fp = popen (self->priv->c1_command, "r");
	
	while (fgets (line, sizeof line, fp)) {
		result = g_strstrip (line);
		gtk_label_set_text (GTK_LABEL (self->priv->cmdResult_lb), result);
	}
	found = TRUE;
	pclose (fp);
	
	if (!found) {
		gtk_label_set_text (GTK_LABEL (self->priv->cmdResult_lb), "result probs");
	}
	
	return found;
}

void desktop_cmd_exec_settings (HDHomePluginItem *hitem, DesktopCmdExec *self)
{
// 	g_warning ("desktop_cmd_exec_settings");
	GtkWidget *dialog = gtk_dialog_new_with_buttons ("Desktop Command Execution Widget Settings", NULL, 0, _("wdgt_bd_save"), GTK_RESPONSE_ACCEPT, NULL);
	
	GtkWidget *content_area = gtk_dialog_get_content_area (GTK_DIALOG (dialog));
	GtkSizeGroup *group = GTK_SIZE_GROUP (gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL));

	GtkWidget *titleBox = gtk_hbox_new (FALSE, 0);
	GtkWidget *titleLabel = gtk_label_new ("Title:");
	gtk_misc_set_alignment (GTK_MISC (titleLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (titleLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, titleLabel);
	
	GtkWidget *titleEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	hildon_entry_set_text (HILDON_ENTRY (titleEntry), self->priv->c1_title);
	gtk_box_pack_start (GTK_BOX (titleBox), titleLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (titleBox), titleEntry, TRUE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (content_area), titleBox);


	
	GtkWidget *commandBox = gtk_hbox_new (FALSE, 0);
	GtkWidget *commandLabel = gtk_label_new ("Command:");
	gtk_misc_set_alignment (GTK_MISC (commandLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (commandLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, commandLabel);

	GtkWidget *commandEntry = hildon_entry_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	hildon_entry_set_text (HILDON_ENTRY (commandEntry), self->priv->c1_command);
	gtk_box_pack_start (GTK_BOX (commandBox), commandLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (commandBox), commandEntry, TRUE, TRUE, 0);
	
	gtk_container_add (GTK_CONTAINER (content_area), commandBox);

	GtkHBox *hbox_upds = GTK_HBOX (gtk_hbox_new (FALSE, 0));
	
	GtkWidget *toggleOnClick = hildon_gtk_toggle_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	gtk_button_set_label (GTK_BUTTON (toggleOnClick), "@Click");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleOnClick), self->priv->c1_updOnClick);
	gtk_container_add (GTK_CONTAINER (hbox_upds), toggleOnClick);

	GtkWidget *toggleOnDesktop = hildon_gtk_toggle_button_new (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT);
	gtk_button_set_label (GTK_BUTTON (toggleOnDesktop), "@Desktop");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggleOnDesktop), self->priv->c1_updOnDesktop);
	gtk_container_add (GTK_CONTAINER (hbox_upds), toggleOnDesktop);

	GtkWidget *updBox = gtk_hbox_new (FALSE, 0);
	GtkWidget *updLabel = gtk_label_new ("Updade:");
	gtk_misc_set_alignment (GTK_MISC (updLabel), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (updLabel), HILDON_MARGIN_DOUBLE, 0);
	gtk_size_group_add_widget (group, updLabel);
	gtk_box_pack_start (GTK_BOX (updBox), updLabel, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (updBox), GTK_WIDGET (hbox_upds), TRUE, TRUE, 0);
	
	gtk_container_add (GTK_CONTAINER (content_area), updBox);

	gtk_widget_show_all (dialog);
	
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
		self->priv->c1_title = g_strdup (hildon_entry_get_text (HILDON_ENTRY (titleEntry)));
		self->priv->c1_command = g_strdup (hildon_entry_get_text (HILDON_ENTRY (commandEntry)));
		self->priv->c1_updOnClick = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleOnClick));
		self->priv->c1_updOnDesktop = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (toggleOnDesktop));

		desktop_cmd_exec_write_settings (self);
		desktop_cmd_exec_update_content (self);
	}
	gtk_widget_destroy (dialog);
}

static void desktop_cmd_exec_check_desktop (GObject *gobject, GParamSpec *pspec, DesktopCmdExec *self)
{
	if (self->priv->c1_updOnClick) {
		desktop_cmd_exec_update_content(self);
	}
// 	g_warning ("desktop_cmd_exec_check_desktop");
}

static void desktop_cmd_exec_dispose (GObject *object)
{
// 	g_warning ("desktop_cmd_exec_dispose");
// 	DesktopCmdExec *self = DESKTOP_CMD_EXEC (object);

	G_OBJECT_CLASS (desktop_cmd_exec_parent_class)->dispose (object);
}

static void desktop_cmd_exec_finalize (GObject *object)
{
// 	g_warning ("desktop_cmd_exec_finalize");
	DesktopCmdExec *self = DESKTOP_CMD_EXEC (object);

	if (self->priv->eventID) {
		g_source_remove (self->priv->eventID);
	}
// 	g_object_unref (self->priv->connection);

	G_OBJECT_CLASS (desktop_cmd_exec_parent_class)->finalize (object);
}

static void desktop_cmd_exec_realize (GtkWidget *widget)
{
// 	g_warning ("desktop_cmd_exec_realize");
	GdkScreen *screen;

	screen = gtk_widget_get_screen (widget);
	gtk_widget_set_colormap (widget, gdk_screen_get_rgba_colormap (screen));

	gtk_widget_set_app_paintable (widget, TRUE);

	GTK_WIDGET_CLASS (desktop_cmd_exec_parent_class)->realize (widget);
}

static gboolean desktop_cmd_exec_expose_event (GtkWidget *widget, GdkEventExpose *event)
{
// 	g_warning ("desktop_cmd_exec_expose_event");
	DesktopCmdExec *self = DESKTOP_CMD_EXEC (widget);

	cairo_t *cr;
	
	cr = gdk_cairo_create(GDK_DRAWABLE (widget->window));

	GdkColor color;
	if (!self->priv->isPressed) {
		gtk_style_lookup_color (gtk_rc_get_style(widget), "DefaultBackgroundColor", &color);
		cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.75);
	} else {
		gtk_style_lookup_color (gtk_rc_get_style(widget), "SelectionColor", &color);
		cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.6);
	}
	
	gint width, height, x, y;
	gint radius = 5;
	width = widget->allocation.width;
	height = widget->allocation.height;
	x = widget->allocation.x;
	y = widget->allocation.y;

	cairo_move_to(cr, x + radius, y);
	cairo_line_to(cr, x + width - radius, y);
	cairo_curve_to(cr, x + width - radius, y, x + width, y, x + width,
				y + radius);
	cairo_line_to(cr, x + width, y + height - radius);
	cairo_curve_to(cr, x + width, y + height - radius, x + width,
				y + height, x + width - radius, y + height);
	cairo_line_to(cr, x + radius, y + height);
	cairo_curve_to(cr, x + radius, y + height, x, y + height, x,
				y + height - radius);
	cairo_line_to(cr, x, y + radius);
	cairo_curve_to(cr, x, y + radius, x, y, x + radius, y);

	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);

	cairo_fill_preserve(cr);
	
	gtk_style_lookup_color (gtk_rc_get_style(widget), "ActiveTextColor", &color);
	cairo_set_source_rgba (cr, color.red/65535.0, color.green/65335.0, color.blue/65535.0, 0.5);
	cairo_set_line_width (cr, 1);
	cairo_stroke (cr);
	
	cairo_destroy(cr);

	return GTK_WIDGET_CLASS (desktop_cmd_exec_parent_class)->expose_event (widget, event);
}

static void desktop_cmd_exec_class_init (DesktopCmdExecClass *klass)
{
// 	g_warning ("desktop_cmd_exec_class_init");
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GtkWidgetClass *widget_class = GTK_WIDGET_CLASS (klass);

	object_class->dispose = desktop_cmd_exec_dispose;
	object_class->finalize = desktop_cmd_exec_finalize;
	
	widget_class->realize = desktop_cmd_exec_realize;
	widget_class->expose_event = desktop_cmd_exec_expose_event;

	g_type_class_add_private (klass, sizeof (DesktopCmdExecPrivate));
}

static void desktop_cmd_exec_class_finalize (DesktopCmdExecClass *klass G_GNUC_UNUSED)
{
}

static void desktop_cmd_exec_init (DesktopCmdExec *self)
{
// 	g_warning ("desktop_cmd_exec_init");
	self->priv = DESKTOP_CMD_EXEC_GET_PRIVATE (self);
	self->priv->eventID = 0;
	self->priv->isPressed = FALSE;
	
	
	hd_home_plugin_item_set_settings (&self->parent, TRUE);
	g_signal_connect (&self->parent, "show-settings", G_CALLBACK (desktop_cmd_exec_settings), self);

	gtk_window_set_default_size (GTK_WINDOW (self), 315, 56);
	
	self->priv->homeWidget = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (self), self->priv->homeWidget);
	gtk_widget_show (self->priv->homeWidget);

	GdkGeometry hints;
	hints.min_width = 515;
	hints.min_height = 40;
	hints.max_width = 515;
	hints.max_height = 40;
	gtk_window_set_geometry_hints (GTK_WINDOW (self), self->priv->homeWidget, &hints, GDK_HINT_MIN_SIZE | GDK_HINT_MAX_SIZE);
	
	desktop_cmd_exec_read_settings (self);
	gtk_widget_set_size_request (GTK_WIDGET (self), 515, 40);
	gtk_window_resize (GTK_WINDOW (self), 515, 40);

	
	desktop_cmd_exec_content_create (self);
	desktop_cmd_exec_update_content (self);
	
	g_signal_connect (self, "notify::is-on-current-desktop", G_CALLBACK (desktop_cmd_exec_check_desktop), self);
}

DesktopCmdExec* desktop_cmd_exec_new (void)
{
	return g_object_new (DESKTOP_CMD_EXEC_TYPE, NULL);
}
