import QtQuick 1.1
import com.nokia.meego 1.0
import "core"
import "harmattan"

PageStackWindow {
    id: appWindow

    initialPage: game

    QueryDialog {
        id: endDialog
        titleText : 'You ' + (won ? 'won' : 'lost') + '!'
        message: 'You ' + (won ? 'won' : 'lost') + ' the Game! Play another?';
        acceptButtonText: 'Play'
        rejectButtonText: 'Exit'
        onAccepted:  {
            game.newGame();
            endDialog.close();
        }
        onRejected: Qt.quit();

        property bool won: false
    }

    Game {
        id: game
        tools: commonTools

        function won() {
            endDialog.won = true;
            endDialog.open();
        }

        function lost() {
            endDialog.won = false;
            endDialog.open();
        }
    }

    Settings {
        id: settings
        onSet: {
            game.columns = numOfColumns;
            game.rows = numOfRows;
            game.mines = numOfMines;
            game.initialize();
            game.newGame();
            appWindow.pageStack.pop();
        }
        onClose: {
            appWindow.pageStack.pop()
        }
    }

    About {
        id: about
        onClose: {
            appWindow.pageStack.pop()
        }
    }

    ToolBarLayout {
        id: commonTools
        visible: true
        ToolButton {
            text: '' + game.flags + ' / ' + game.mines
            iconSource: 'core/images/flag.svg'
        }
        ToolButton {
            text: '00:00'
        }
        ToolIcon {
            platformIconId: "toolbar-view-menu";
            anchors.right: parent===undefined ? undefined : parent.right
            onClicked: (myMenu.status == DialogStatus.Closed) ? myMenu.open() : myMenu.close()
        }
    }

    Menu {
        id: myMenu
        visualParent: pageStack
        MenuLayout {
            MenuItem { text: "New Game"; onClicked : game.newGame(); }
            MenuItem { text: "Settings"; onClicked: appWindow.pageStack.push(settings); }
            MenuItem { text: "About"; onClicked: appWindow.pageStack.push(about); }
        }
    }
}
