#!/usr/bin/python2.5
import osso
import gtk
import os
import csv
try:
  from gnome import gnomevfs
except ImportError:
  import gnomevfs

# This program is based on sample taken from :
# http://pymaemo.garage.maemo.org/documentation/pymaemo_tutorial/python_maemo_howto.html#link18

def callback_func(interface, method, arguments, user_data):
    osso_c = user_data
    print "--"
    print "-- dbus-switchboard: Received an RPC to %s." % method
    print "-- dbus-switchboard: RPC had arguments %s." % arguments
    print "-- dbus-switchboard: Interface is %s " % interface
    print "-- dbus-switchboard: user_data is %s " % user_data

    #Different apps and launch strings require filenames in different formats
    #Dbus switchboard currently provides three formats for input filename :
    #
    # realparams  exact input filename string (no fixup)
    # realparams2 only fixup is to ensure filename does not start with file://
    # params      substitutes troublesome symbols to hex encodings and ensures it starts with file://
    # params2     hex encoded symbols (as above) but ensure does NOT start with file:// 

    # fixup1 strips off the extra stuff added by Maemo 5.

    fixup1 = "%s" % arguments
    fixup1 = fixup1.replace("['//", "/")
    fixup1 = fixup1.replace("['", "")
    fixup1 = fixup1.replace("']", "")

    params = "%s" % fixup1 
    params = params.replace("[", "%5B")
    params = params.replace("]", "%5D")
    params = params.replace("+", "%2B")
    params = params.replace(" ", "%20")
    params = params.replace(",", "%2C")
    params = params.replace("(", "%28")
    params = params.replace(")", "%29")
    params = params.replace("'", "%27")
    params = params.replace("file:///", "/")
    if (params.lower().startswith("file://")):
       params2 = params.replace("file://", "")
    else:
       if (params.lower().startswith("upnpav://")):
          params2 = params
       else:
          params2 = params
          params = "file://" + params

    realparams = "%s" % fixup1
    realparams = realparams.replace("%5B", "[")
    realparams = realparams.replace("%5D", "]")
    realparams = realparams.replace("%2B", "+")
    realparams = realparams.replace("%20", " ")
    realparams = realparams.replace("%2C", ",")
    realparams = realparams.replace("%28", "(")
    realparams = realparams.replace("%29", ")")
    realparams = realparams.replace("%27", "'")
    realparams = realparams.replace("%22", '"')
    realparams = realparams.replace("%3A", ":")
    realparams = realparams.replace("file:///", "/")
    if (realparams.lower().startswith("file://")):
       realparams2 = realparams.replace("file://", "")
    else:
       if (realparams.lower().startswith("upnpav://")):
          realparams2 = realparams
       else:
          realparams2 = realparams
          realparams = "file://" + realparams

    foundhandler = "no"

    print "------"
    print "-- params : " + params
    print "-- params2 : " + params2
    print "-- realparams : " + realparams
    print "-- realparams2 : " + realparams2
    print "------"

    docmimetype = "application/octet-stream"
    if '://' not in params2:
      docmimetype = gnomevfs.get_mime_type(params2)
      print "-- params2 mimetype is:  %s " % docmimetype
      print "------"

    #verify our configuration files exist in /home/user
    if (os.path.exists("/usr/lib/dbus-switchboard/dbus-switch-xref.cfg") and os.path.exists("/usr/lib/dbus-switchboard/dbus-switch-apps.cfg")):
        #Check XREFS
        #first for loop scans the xref file to match file extension with appname handler
        #column[0] : file extension
        #column[1] : appname
        #column[2] : optional protocol type
        rdr_xref = csv.reader(open("/usr/lib/dbus-switchboard/dbus-switch-xref.cfg", "rb"))
        for rowxref in rdr_xref:

            #Add protocol checks (if specified) for this xref
            #Useful for links like tel: or ssh: links which may not have an extension to associate against
            ProtocolDetect = "no"
            # print "("+rowxref[0].upper()+") ("+realparams[-6:-2]+")"
            if rowxref[2] != "" and realparams.startswith(rowxref[2]):
                print "protocol!"
                ProtocolDetect = "yes"

            # Modified comparison of file extension to be case insensitive
            if (rowxref[0] != "" and realparams.upper().endswith(rowxref[0].upper())) or ProtocolDetect == "yes":
                rdr_apps = csv.reader(open("/usr/lib/dbus-switchboard/dbus-switch-apps.cfg", "rb"))

                #Check APPS 
                #this loop looks up the launch info for the designated appname 
                #column[0] : holds appname
                #column[1] : future use for indicating that this app is cli or hildon/dbus
                #column[2] : the launch string, with placeholder %params% which we will substitute params into
                for rowapp in rdr_apps:
                    if rowapp[0] == rowxref[1]:
                        osso_sysnote = osso.SystemNote(osso_c)
                        osso_sysnote.system_note_infoprint("Launching " + rowapp[0])

                        launchstr = "%s" % rowapp[2]
                        launchstr = launchstr.replace("%params%", params)
                        launchstr = launchstr.replace("%params2%", params2)
                        launchstr = launchstr.replace("%realparams%", realparams)
                        launchstr = launchstr.replace("%realparams2%", realparams2)
                        runcmd = "/usr/bin/run-standalone.sh " + launchstr + " &"
                        print "-- dbus-switchboard (runcmd) : %s" % runcmd
                        os.system(runcmd)
                        foundhandler = "yes"
                        return

    if foundhandler == "no":
        print "no handler found"

        print "**Load Mime XRef**"
        MIMEXREFPATH = '/home/user/.mimetypes/user-mimetypes.list'
        print '@ ' + MIMEXREFPATH
        xrefdefaults = {}
        fp = open(MIMEXREFPATH)
        for line in fp:
            if line.startswith('#'):
                continue
            elif line == "":
                continue
            elif '=' not in line:
                continue
            key = line.split('=')[0]
            val = line.split('=')[1].strip()
            xrefdefaults[key] = val
#            print key + ' : ' + val
            if key == docmimetype:
               print 'found handler for %s: %s' % ( key, val )
               if val != 'none':
                 rdr_apps = csv.reader(open("/usr/lib/dbus-switchboard/dbus-switch-apps.cfg", "rb"))

                 #Check APPS 
                 #this loop looks up the launch info for the designated appname 
                 #column[0] : holds appname
                 #column[1] : future use for indicating that this app is cli or hildon/dbus
                 #column[2] : the launch string, with placeholder %params% which we will substitute params into
                 for rowapp in rdr_apps:
                    # print "comparing (%s) with (%s)" % (rowapp[0], val)
                    if rowapp[0] == val:
                        osso_sysnote = osso.SystemNote(osso_c)
                        osso_sysnote.system_note_infoprint("Launching " + rowapp[0])

                        launchstr = "%s" % rowapp[2]
                        launchstr = launchstr.replace("%params%", params)
                        launchstr = launchstr.replace("%params2%", params2)
                        launchstr = launchstr.replace("%realparams%", realparams)
                        launchstr = launchstr.replace("%realparams2%", realparams2)
                        runcmd = "/usr/bin/run-standalone.sh " + launchstr + " &"
                        print "-- dbus-switchboard (runcmd) : %s" % runcmd
                        os.system(runcmd)
                        foundhandler = "yes"
                        return
        filename_split = realparams.split(".")
        filename_ext = "." + filename_split[-1]
        nohandmsg = "No Handler configured for %s (%s)" % (docmimetype, filename_ext) 
        osso_sysnote = osso.SystemNote(osso_c)
        osso_sysnote.system_note_infoprint(nohandmsg)


osso_c = osso.Context("dbus-switchboard", "0.0.1", False)
print "dbus-switchboard started"
osso_rpc = osso.Rpc(osso_c)
osso_rpc.set_rpc_callback("org.dbus.switchsvc",
    "/org/dbus/switchservice",
    "org.dbus.switchsvc", callback_func, osso_c)
gtk.main()
