#include "searchoptionsdialog.h"
#include "../base/settings.h"
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QScrollArea>
#include <QGridLayout>

SearchOptionsDialog::SearchOptionsDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_serviceCheckbox(new QCheckBox(tr("Show service option"), this)),
    m_typeCheckbox(new QCheckBox(tr("Show type option"), this)),
    m_orderCheckbox(new QCheckBox(tr("Show order option"), this)),
    m_timeCheckbox(new QCheckBox(tr("Show time option"), this)),
    m_durationCheckbox(new QCheckBox(tr("Show duration option"), this)),
    m_languageCheckbox(new QCheckBox(tr("Show language option"), this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Save, Qt::Vertical, this)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Search dialog options"));
    this->setAttribute(Qt::WA_DeleteOnClose, false);

    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(m_serviceCheckbox);
    vbox->addWidget(m_typeCheckbox);
    vbox->addWidget(m_orderCheckbox);
    vbox->addWidget(m_timeCheckbox);
    vbox->addWidget(m_durationCheckbox);
    vbox->addWidget(m_languageCheckbox);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(saveSettings()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    this->loadSettings();
    this->onOrientationChanged();
}

void SearchOptionsDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void SearchOptionsDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void SearchOptionsDialog::loadSettings() {
    m_serviceCheckbox->setChecked(Settings::instance()->showSearchSite());
    m_typeCheckbox->setChecked(Settings::instance()->showSearchType());
    m_orderCheckbox->setChecked(Settings::instance()->showSearchOrder());
    m_timeCheckbox->setChecked(Settings::instance()->showSearchTime());
    m_durationCheckbox->setChecked(Settings::instance()->showSearchDuration());
    m_languageCheckbox->setChecked(Settings::instance()->showSearchLanguage());
}

void SearchOptionsDialog::saveSettings() {
    Settings::instance()->setShowSearchSite(m_serviceCheckbox->isChecked());
    Settings::instance()->setShowSearchType(m_typeCheckbox->isChecked());
    Settings::instance()->setShowSearchOrder(m_orderCheckbox->isChecked());
    Settings::instance()->setShowSearchTime(m_timeCheckbox->isChecked());
    Settings::instance()->setShowSearchDuration(m_durationCheckbox->isChecked());
    Settings::instance()->setShowSearchLanguage(m_languageCheckbox->isChecked());

    this->accept();
}
