#ifndef DATABASE_H
#define DATABASE_H

#include <qplatformdefs.h>
#include <QSqlDatabase>
#ifdef MEEGO_EDITION_HARMATTAN
#include "../harmattan/transferitem.h"
#elif (defined (Q_WS_MAEMO_5))
#include "../maemo5_gui/transferitem.h"
#elif (defined (SYMBIAN_OS))
#include "../symbian/transferitem.h"
#elif (defined (Q_OS_UNIX))
#include "../tv/transferitem.h"
#endif

class Database : public QObject
{
    Q_OBJECT

public:
    explicit Database(QObject *parent = 0);
    ~Database() {}
    void restoreAccounts();

    static Database* instance();

public slots:
    void initialize();
    QList< QSharedPointer<TransferItem> > getStoredDownloads();
    bool storeDownload(QSharedPointer<TransferItem> transfer);
    bool removeStoredDownload(const QString &id);
    bool updateStoredDownload(const QString &id, const QString &key, const QVariant &value);
    bool setYouTubeUsername(const QString &user);
    bool setYouTubeAccessToken(const QString &token);
    bool setDailymotionUsername(const QString &user);
    bool setDailymotionAccessToken(const QString &token, const QString &refresh);
    bool setVimeoUsername(const QString &user);
    bool setVimeoAccessToken(const QString &token, const QString &secret);
    bool storeFacebookAccount(const QString &token);
    bool deleteFacebookAccount();
    bool storeTwitterAccount(const QString &token, const QString &secret);
    bool deleteTwitterAccount();

signals:
    void alert(const QString &message);
    void error(const QString &errorString);
    void info(const QString &message);
    void gotYouTubeAccount(const QString &user, const QString &token, const QString &refresh);
    void gotDailymotionAccount(const QString &user, const QString &token, const QString &refresh);
    void gotVimeoAccount(const QString &user, const QString &token, const QString &secret);
    void gotFacebookAccount(const QString &token);
    void gotTwitterAccount(const QString &token, const QString &secret);

private:
    void restoreYouTubeAccount();
    void restoreDailymotionAccount();
    void restoreVimeoAccount();
    void restoreFacebookAccount();
    void restoreTwitterAccount();

private:
    QSqlDatabase m_database;
};

#endif // DATABASE_H
