#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include "abstractdialog.h"

class MediaPlayerSelector;
class ConcurrentTransfersSelector;
class ScreenOrientationSelector;
class LanguageSelector;
class PlaybackFormatDialog;
class DownloadFormatDialog;
class SearchOptionsDialog;
class NetworkProxyDialog;
class QCheckBox;
class QLineEdit;
class QPushButton;
class QScrollArea;
class QDialogButtonBox;
class QGridLayout;
class QMaemo5ValueButton;

class SettingsDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);

private slots:
    void saveSettings();
    void showFileDialog();
    void showSearchOptionsDialog();
    void showPlaybackFormatDialog();
    void showDownloadFormatDialog();
    void showNetworkProxyDialog();
    void onMediaPlayerChanged(const QString &player);

private:
    void loadSettings();
    void setLandscapeLayout();
    void setPortraitLayout();
    void scheduleEvents();
    void clearEvents();
    
private:
    QCheckBox *m_transferStatusCheckbox;
    QCheckBox *m_safeSearchCheckbox;
    QCheckBox *m_eventFeedCheckbox;
    QCheckBox *m_clipboardCheckbox;
    QPushButton *m_searchButton;
    QPushButton *m_playbackButton;
    QPushButton *m_downloadButton;
    QPushButton *m_proxyButton;
    QMaemo5ValueButton *m_downloadFolderSelector;
    QString m_downloadPath;
    MediaPlayerSelector *m_mediaPlayerSelector;
    ConcurrentTransfersSelector *m_concurrentSelector;
    ScreenOrientationSelector *m_orientationSelector;
    LanguageSelector *m_languageSelector;
    QLineEdit *m_mediaPlayerCommandEdit;
    QDialogButtonBox *m_buttonBox;
    QScrollArea *m_scrollArea;
    PlaybackFormatDialog *m_playbackDialog;
    DownloadFormatDialog *m_downloadDialog;
    SearchOptionsDialog *m_searchDialog;
    NetworkProxyDialog *m_proxyDialog;
    QGridLayout *m_grid;
    bool m_eventFeedEnabled;
};

#endif // SETTINGSDIALOG_H
