#ifndef VIDEOSERVICESELECTOR_H
#define VIDEOSERVICESELECTOR_H

#include "../base/enums.h"
#include <QMaemo5ValueButton>

class VideoServiceModel;
class QMaemo5ListPickSelector;

class VideoServiceSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit VideoServiceSelector(const QString &text, QWidget *parent = 0);
    void setValue(Services::VideoService value);
    Services::VideoService currentValue();

private slots:
    void onSelected();
    
signals:
    void valueChanged(Services::VideoService value);
    
private:
    VideoServiceModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // VIDEOSERVICESELECTOR_H
