#include "homewindow.h"
#include "dbusadaptor.h"
#include "transferitem.h"
#include "../base/utils.h"
#include "../base/session.h"
#include "../base/settings.h"
#include "../base/commentitem.h"
#include "../base/groupitem.h"
#include "../base/playlistitem.h"
#include "../base/useritem.h"
#include <QApplication>
#include <QTranslator>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    app.setApplicationName("cuteTube");
    app.setApplicationVersion(Utils::versionNumberString());

    qRegisterMetaType< QSharedPointer<CommentItem> >("QSharedPointer<CommentItem>");
    qRegisterMetaType< QSharedPointer<GroupItem> >("QSharedPointer<GroupItem>");
    qRegisterMetaType< QSharedPointer<PlaylistItem> >("QSharedPointer<PlaylistItem>");
    qRegisterMetaType< QSharedPointer<TransferItem> >("QSharedPointer<TransferItem>");
    qRegisterMetaType< QSharedPointer<UserItem> >("QSharedPointer<UserItem>");
    qRegisterMetaType< QSharedPointer<VideoItem> >("QSharedPointer<VideoItem>");

    new Session;

    if (!Settings::instance()->language().isEmpty()) {
        QTranslator translator;
        translator.load(QString("/opt/cutetube/translations/cutetube_%1").arg(Settings::instance()->language()));
        app.installTranslator(&translator);
    }

    HomeWindow window;
    new DBusAdaptor(&window);
    QDBusConnection connection = QDBusConnection::sessionBus();
    connection.registerService("com.maemo.cuteTube");
    connection.registerObject("/", &window);

    window.show();

    QObject::connect(&app, SIGNAL(aboutToQuit()), Session::instance(), SLOT(deleteLater()));

    return app.exec();
}
