#ifndef YOUTUBEAUTHDIALOG_H
#define YOUTUBEAUTHDIALOG_H

#include "abstractdialog.h"

class WebView;
class QProgressBar;
class QGridLayout;

class YouTubeAuthDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeAuthDialog(const QString &accountName, QWidget *parent = 0);

private:
    inline void setLandscapeLayout() { this->setFixedHeight(340); }
    inline void setPortraitLayout() { this->setFixedHeight(600); }

private slots:
    void checkTitleForCode(const QString &title);

private:
    QString m_name;
    WebView *m_webView;
    QProgressBar *m_progressBar;
    QGridLayout *m_grid;
};

#endif // YOUTUBEAUTHDIALOG_H
