#ifndef VIMEOGROUPLISTTAB_H
#define VIMEOGROUPLISTTAB_H

#include "abstracttab.h"
#include "../base/groupitem.h"

class ListView;
class VimeoGroupListModel;
class QLabel;
class QGridLayout;
class QModelIndex;

class VimeoGroupListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit VimeoGroupListTab(QWidget *parent = 0);
    void setGroupFeed(const QUrl &feed);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);

private:
    ListView *m_listView;
    VimeoGroupListModel *m_model;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // VIMEOGROUPLISTTAB_H
