#include "dailymotionplaylistlisttab.h"
#include "dailymotionplaylistdelegate.h"
#include "dailymotionplaylistvideoswindow.h"
#include "listview.h"
#include "../base/dailymotionplaylistlistmodel.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include <QLabel>
#include <QGridLayout>
#include <QMaemo5Style>

DailymotionPlaylistListTab::DailymotionPlaylistListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new DailymotionPlaylistListModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No playlists found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new DailymotionPlaylistDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMorePlaylists()));

    this->onOrientationChanged();
}

void DailymotionPlaylistListTab::setPlaylistFeed(const QUrl &feed) {
    m_model->getPlaylists(feed);
}

void DailymotionPlaylistListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionPlaylistListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionPlaylistListTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void DailymotionPlaylistListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void DailymotionPlaylistListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showPlaylist(m_model->get(index.row()));
    }
}

void DailymotionPlaylistListTab::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    DailymotionPlaylistVideosWindow *window = new DailymotionPlaylistVideosWindow(playlist, WindowStack::instance()->currentWindow());
    window->show();
}
