#include "dailymotionnewplaylistdialog.h"
#include <QScrollArea>
#include <QLineEdit>
#include <QTextEdit>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QGridLayout>
#include <QLabel>

DailymotionNewPlaylistDialog::DailymotionNewPlaylistDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_titleEdit(new QLineEdit(this)),
    m_descriptionEdit(new QTextEdit(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_doneButton(m_buttonBox->addButton(tr("Done"), QDialogButtonBox::AcceptRole)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("New playlist"));

    QLabel *titleLabel = new QLabel(tr("Title"), this);
    QLabel *descriptionLabel = new QLabel(tr("Description"), this);
    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(titleLabel);
    vbox->addWidget(m_titleEdit);
    vbox->addWidget(descriptionLabel);
    vbox->addWidget(m_descriptionEdit);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_doneButton->setEnabled(false);
    m_descriptionEdit->setAcceptRichText(false);

    this->connect(m_titleEdit, SIGNAL(textChanged(QString)), this, SLOT(onTitleTextChanged(QString)));
    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(createPlaylist()));

    this->onOrientationChanged();
}

void DailymotionNewPlaylistDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void DailymotionNewPlaylistDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void DailymotionNewPlaylistDialog::onTitleTextChanged(const QString &text) {
    m_doneButton->setEnabled(!text.isEmpty());
}

void DailymotionNewPlaylistDialog::createPlaylist() {
    QVariantMap playlist;
    playlist.insert("title", m_titleEdit->text());
    playlist.insert("description", m_descriptionEdit->toPlainText());
    emit playlistCreated(playlist);
    this->accept();
}
