#ifndef YOUTUBESUBSCRIPTIONLISTMODEL_H
#define YOUTUBESUBSCRIPTIONLISTMODEL_H

#include "useritem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

#ifndef QML_USER_INTERFACE
class ThumbnailCache;
#endif

class YouTubeSubscriptionListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        SubscriptionIdRole,
        UsernameRole,
        ChannelNameRole,
#ifndef QML_USER_INTERFACE
        AvatarRole,
#endif
        AvatarUrlRole,
        VideoCountRole,
        DescriptionRole,
        ViewCountRole,
        SubscriberCountRole,
        SubscriptionRole
    };

public:
    explicit YouTubeSubscriptionListModel(QObject *parent = 0);
    ~YouTubeSubscriptionListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<UserItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE UserItem* getFromQML(int row) const;
#endif

private slots:
    void onSubscriptionAdded(int row);
    void onSubscriptionRemoved(int row);
#ifndef QML_USER_INTERFACE
    void onThumbnailReady();
#endif

signals:
    void countChanged(int count);

#ifndef QML_USER_INTERFACE
private:
    ThumbnailCache *m_cache;
#endif
};

#endif // YOUTUBESUBSCRIPTIONLISTMODEL_H
