#include "vimeouseralbumlistmodel.h"
#include "vimeo.h"
#ifndef QML_USER_INTERFACE
#include "thumbnailcache.h"
#endif

VimeoUserAlbumListModel::VimeoUserAlbumListModel(QObject *parent) :
    QAbstractListModel(parent)
  #ifndef QML_USER_INTERFACE
    ,m_cache(new ThumbnailCache)
  #endif
{
    QHash<int, QByteArray> roles;
    roles[IdRole] = "id";
    roles[AlbumIdRole] = "albumId";
    roles[TitleRole] = "title";
    roles[ArtistRole] = "artist";
    roles[DateRole] = "date";
    roles[VideoCountRole] = "videoCount";
#ifndef QML_USER_INTERFACE
    roles[ThumbnailRole] = "thumbnail";
#endif
    roles[ThumbnailUrlRole] = "thumbnailUrl";
    roles[DescriptionRole] = "description";
    this->setRoleNames(roles);
#ifndef QML_USER_INTERFACE
    this->connect(m_cache, SIGNAL(thumbnailReady()), this, SLOT(onThumbnailReady()));
#endif
    if (!Vimeo::instance()->albumsLoaded()) {
        Vimeo::instance()->getAlbums();
    }

    this->connect(Vimeo::instance(), SIGNAL(albumAddedToCache(int)), this, SLOT(onAlbumAdded(int)));
    this->connect(Vimeo::instance(), SIGNAL(albumRemovedFromCache(int)), this, SLOT(onAlbumRemoved(int)));
    this->connect(Vimeo::instance(), SIGNAL(albumUpdated(int)), this, SLOT(onAlbumUpdated(int)));
}

VimeoUserAlbumListModel::~VimeoUserAlbumListModel() {
#ifndef QML_USER_INTERFACE
    delete m_cache;
    m_cache = 0;
#endif
}

void VimeoUserAlbumListModel::onAlbumAdded(int row) {
    this->beginInsertRows(QModelIndex(), row, row);
    this->endInsertRows();
    emit countChanged(this->rowCount());
}

void VimeoUserAlbumListModel::onAlbumRemoved(int row) {
    this->beginRemoveRows(QModelIndex(), row, row);
    this->endRemoveRows();
    emit countChanged(this->rowCount());
}

void VimeoUserAlbumListModel::onAlbumUpdated(int row) {
    emit dataChanged(this->index(row), this->index(row));
}

int VimeoUserAlbumListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return Vimeo::instance()->albums()->size();
}

QVariant VimeoUserAlbumListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->id();
    case AlbumIdRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->playlistId();
    case TitleRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->title();
    case ArtistRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->artist();
    case DateRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->date();
    case VideoCountRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->videoCount();
#ifndef QML_USER_INTERFACE
    case ThumbnailRole:
        return m_cache->thumbnail(Vimeo::instance()->albums()->at(index.row()).data()->thumbnailUrl(), QSize(120, 90));
#endif
    case ThumbnailUrlRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->thumbnailUrl();
    case DescriptionRole:
        return Vimeo::instance()->albums()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

QVariant VimeoUserAlbumListModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}

QSharedPointer<PlaylistItem> VimeoUserAlbumListModel::get(int row) const {
    return QSharedPointer<PlaylistItem>(Vimeo::instance()->albums()->at(row));
}

#ifdef QML_USER_INTERFACE
PlaylistItem* VimeoUserAlbumListModel::getFromQML(int row) const {
    return Vimeo::instance()->albums()->at(row).data();
}
#endif

#ifndef QML_USER_INTERFACE
void VimeoUserAlbumListModel::onThumbnailReady() {
    emit dataChanged(this->index(0), this->index(this->rowCount() - 1));
}
#endif
