#include "homescreenmodel.h"

HomescreenModel::HomescreenModel(QObject *parent) :
    QAbstractListModel(parent)
{
    QHash<int, QByteArray> roles;
    roles[NameRole] = "name";
    roles[IconSourceRole] = "iconSource";
    this->setRoleNames(roles);

    m_list.append(QPair<QString, QString>(tr("My Channel"), "images/mychannel.png"));
    m_list.append(QPair<QString, QString>(tr("Latest Videos"), "images/latest.png"));
    m_list.append(QPair<QString, QString>(tr("Categories"), "images/categories.png"));
    m_list.append(QPair<QString, QString>(tr("Social"), "images/social.png"));
    m_list.append(QPair<QString, QString>(tr("Search"), "images/search.png"));
    m_list.append(QPair<QString, QString>(tr("Queue"), "images/queue.png"));
    m_list.append(QPair<QString, QString>(tr("Transfers"), "images/transfers.png"));
    m_list.append(QPair<QString, QString>(tr("Archive"), "images/archive.png"));
    m_list.append(QPair<QString, QString>(tr("Accounts"), "images/accounts.png"));
}

int HomescreenModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant HomescreenModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case NameRole:
        return m_list.at(index.row()).first;
    case IconSourceRole:
        return m_list.at(index.row()).second;
    default:
        return QVariant();
    }
}

QVariant HomescreenModel::data(int row, const QByteArray &role) const {
    return this->data(this->index(row), this->roleNames().key(role));
}
