#ifndef ENUMS_H
#define ENUMS_H

#include <QObject>
#include <QtNetwork/QNetworkProxy>

class Services : public QObject
{
    Q_OBJECT

    Q_ENUMS(VideoService)
    Q_ENUMS(SharingService)

public:
    enum VideoService {
        YouTube = 0,
        Dailymotion,
        Vimeo,
        NoService
    };

public:
    enum SharingService {
        Facebook = 0,
        Twitter,
        Email,
        Clipboard
    };
};

class Videos : public QObject
{
    Q_OBJECT

    Q_ENUMS(VideoFormat)

public:
    enum VideoFormat {
        LQ = 0,
        Normal,
        HQ,
        HD,
        SuperHD,
        Unknown
    };
};

class Queries : public QObject
{
    Q_OBJECT

    Q_ENUMS(QueryType)
    Q_ENUMS(QueryOrder)
    Q_ENUMS(TimeFilter)
    Q_ENUMS(DurationFilter)

public:
    enum QueryType {
        Videos = 0,
        Playlists,
        Users,
        Groups
    };

    enum QueryOrder {
        Date = 0,
        Relevance,
        Views,
        Rating
    };

    enum TimeFilter {
        None = 0,
        AllTime,
        Today,
        ThisWeek,
        ThisMonth
    };

    enum DurationFilter {
        Any = 0,
        Short,
        Medium,
        Long
    };
};

class ScreenOrientation : public QObject
{
    Q_OBJECT

    Q_ENUMS(Orientation)

public:
    enum Orientation {
        Automatic = 0,
        LockPortrait,
        LockLandscape
    };
};

class Transfers : public QObject
{
    Q_OBJECT

    Q_ENUMS(TransferStatus)
    Q_ENUMS(TransferPriority)
    Q_ENUMS(TransferType)

public:
    enum TransferStatus {
        Paused = 0,
        Cancelled,
        Failed,
        Completed,
        Queued,
        Connecting,
        Downloading,
        Uploading,
        Converting
    };

    enum TransferPriority {
        HighPriority = 0,
        NormalPriority,
        LowPriority
    };

    enum TransferType {
        Download = 0,
        Upload
    };
};

class NetworkProxyType : public QObject
{
    Q_OBJECT

    Q_ENUMS(ProxyType)

public:
    enum ProxyType {
        Socks5Proxy = QNetworkProxy::Socks5Proxy,
        HttpProxy = QNetworkProxy::HttpProxy,
        HttpCachingProxy = QNetworkProxy::HttpCachingProxy
    };
};

#endif // ENUMS_H
