#ifndef DAILYMOTIONUSERPLAYLISTLISTMODEL_H
#define DAILYMOTIONUSERPLAYLISTLISTMODEL_H

#include "playlistitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class DailymotionUserPlaylistListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        IdRole = Qt::UserRole + 1,
        PlaylistIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        VideoCountRole,
        DescriptionRole
    };

public:
    explicit DailymotionUserPlaylistListModel(QObject *parent = 0);
    ~DailymotionUserPlaylistListModel() {}
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
    QSharedPointer<PlaylistItem> get(int row) const;
#ifdef QML_USER_INTERFACE
    Q_INVOKABLE PlaylistItem* getFromQML(int row) const;
#endif

private slots:
    void onPlaylistAdded(int row);
    void onPlaylistRemoved(int row);
    void onPlaylistUpdated(int row);

signals:
    void countChanged(int count);
};

#endif // DAILYMOTIONUSERPLAYLISTLISTMODEL_H
