#ifndef TRANSFERMANAGER_H
#define TRANSFERMANAGER_H

#include <QObject>
#include <QVariantMap>
#include <qplatformdefs.h>
#ifdef MEEGO_EDITION_HARMATTAN
#include "../harmattan/transferitem.h"
#elif (defined (Q_WS_MAEMO_5))
#include "../maemo5_gui/transferitem.h"
#elif (defined (SYMBIAN_OS))
#include "../symbian/transferitem.h"
#endif


class TransferManager : public QObject
{
    Q_OBJECT

public:
    explicit TransferManager(QObject *parent = 0);
    ~TransferManager();
    inline QNetworkAccessManager* networkAccessManager() const { return m_nam; }
    inline void setNetworkAccessManager(QNetworkAccessManager *manager) { m_nam = manager; }
    Q_INVOKABLE void restoreStoredDownloads();
    Q_INVOKABLE int concurrentTransfers() const;
    Q_INVOKABLE inline int transferCount() const { return this->transferList()->size(); }
    inline QList< QSharedPointer<TransferItem> >* transferList() const { return m_transfers; }
    Q_INVOKABLE void addDownloadTransfer(VideoItem *video, bool saveAsAudio = false, bool notify = true);
    void addDownloadTransfer(QSharedPointer<VideoItem> video, bool saveAsAudio = false, bool notify = true);
    Q_INVOKABLE void addDownloadTransfers(QList<VideoItem*> videos, bool saveAsAudio = false);
    void addDownloadTransfers(QList< QSharedPointer<VideoItem> >videos, bool saveAsAudio = false);
    Q_INVOKABLE void addUploadTransfer(const QVariantMap &metadata);
#ifdef MEEGO_EDITION_HARMATTAN
    Q_INVOKABLE inline bool harmattanTransferUIVisible() const { return !m_transferUI ? false : m_transferUI->isTUIVisible(); }
#endif
    static TransferManager* instance();

public slots:
    void onMaximumConcurrentTransfersChanged(int oldMaximum, int newMaximum);

private:
    QString generateTransferId(QString seedFileName) const;
    QSharedPointer<TransferItem> getNextTransfer() const;
    QSharedPointer<TransferItem> getTransfer(TransferItem *transfer) const;
    bool removeTransfer(QSharedPointer<TransferItem> transfer);

private slots:
    void onTransferStatusChanged(Transfers::TransferStatus status);
    void onTransferFileNameChanged(const QString &fileName);
#ifndef MEEGO_EDITION_HARMATTAN
    void onTransferPriorityChanged(Transfers::TransferPriority priority);
#endif
    void onTransferVideoFormatChanged(Videos::VideoFormat videoFormat);
    void onTransferSaveAsAudioChanged(bool saveAsAudio);
    void onTransferSizeChanged(qint64 size);
    void onTransferCompleted(QSharedPointer<TransferItem> transfer);
    void onTransferCancelled(QSharedPointer<TransferItem> transfer);
    
signals:
    void alert(const QString &message);
    void transferRemoved(int row);

private:
    QNetworkAccessManager *m_nam;
    QList< QSharedPointer<TransferItem> > *m_transfers;
#ifdef MEEGO_EDITION_HARMATTAN
    Client *m_transferUI;
#endif
};

#endif // TRANSFERMANAGER_H
