#ifndef EXTRACTORPLUGIN_H
#define EXTRACTORPLUGIN_H

#include "extractorinterface.h"
#include <QObject>

class ExtractorPlugin : public QObject, ExtractorInterface
{
    Q_OBJECT
    Q_INTERFACES(ExtractorInterface)

public:
    explicit ExtractorPlugin(QObject *parent = 0);
    ~ExtractorPlugin();
    ExtractorPlugin* create(QObject *parent = 0);
    QString versionNumber();
    QUrl youtubeRequestUrl(const QString &id);
    QUrl dailymotionRequestUrl(const QString &id);
    QUrl vimeoRequestUrl(const QString &id);
    QVariantList extractYouTubeFormats(QString page);
    QVariantList extractDailymotionFormats(QString page);
    QVariantList extractVimeoFormats(QString page);

private:
    QString decryptYouTubeSignature(const QString &s);
};

#endif // EXTRACTORPLUGIN_H
