#ifndef EXTRACTORINTERFACE_H
#define EXTRACTORINTERFACE_H

#include <QtPlugin>
#include <QVariantList>

class ExtractorPlugin;

class ExtractorInterface
{

public:
    virtual ~ExtractorInterface() {}
    virtual ExtractorPlugin* create(QObject *parent = 0) = 0;
    virtual QString versionNumber() = 0;
    virtual QUrl youtubeRequestUrl(const QString &id) = 0;
    virtual QUrl dailymotionRequestUrl(const QString &id) = 0;
    virtual QUrl vimeoRequestUrl(const QString &id) = 0;
    virtual QVariantList extractYouTubeFormats(QString page) = 0;
    virtual QVariantList extractDailymotionFormats(QString page) = 0;
    virtual QVariantList extractVimeoFormats(QString page) = 0;
};

Q_DECLARE_INTERFACE(ExtractorInterface, "com.marxian.cuteTube.ExtractorInterface/1.0")

#endif // EXTRACTORINTERFACE_H
