#ifndef EVENTS_H
#define EVENTS_H

#include "event.h"
#include <QVariant>
#include <qplatformdefs.h>

class YouTube;
class Dailymotion;
class Vimeo;
class Database;
class QNetworkAccessManager;
class QDBusMessage;
class QDBusError;

class Events : public QObject
{
    Q_OBJECT

public:
    Events(QObject *parent = 0);
    ~Events() {}

public slots:
    bool enableSync();
    bool disableSync();
    void startSync();

private slots:
    void abortSync();
    void syncSuccess();
    void syncFailed();
    void getEvents();
    void getYouTubeEvents();
    void processYouTubeEvents();
    void getDailymotionEvents();
    void processDailymotionEvents();
    void getVimeoEvents();
    void processVimeoEvents();
#ifdef MEEGO_EDITION_HARMATTAN
    void onThumbnailDownloaded();
    void dbusRequestCompleted(const QDBusMessage &message);
    void dbusError(const QDBusError &error, const QDBusMessage &message);
#endif

private:
    void init();
    void addEvents();
#ifdef MEEGO_EDITION_HARMATTAN
    QString base64SerializedVariant(const QVariant &value) const;
    void downloadThumbnails();
    void clearThumbnails();
#endif

private:
    QNetworkAccessManager *m_nam;
    Database *m_database;
    YouTube *m_youtube;
    Dailymotion *m_dailymotion;
    Vimeo *m_vimeo;
    QList<Event> m_events;
    int m_index;
    bool m_initialized;
};

#endif  //  EVENTS_H
