#ifndef YOUTUBEUSERLISTWINDOW_H
#define YOUTUBEUSERLISTWINDOW_H

#include "stackedwindow.h"

class YouTubeUserListModel;
class ListView;
class QLabel;
class QModelIndex;

class YouTubeUserListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit YouTubeUserListWindow(QWidget *parent);
    void setFeed(const QUrl &feed);
    void search(const QString &query);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showUserChannel(const QString &userId);

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);

private:
    YouTubeUserListModel *m_model;
    ListView *m_listView;
    QLabel *m_noResultsLabel;
};

#endif // YOUTUBEUSERLISTWINDOW_H
