#ifndef DAILYMOTIONSUBSCRIPTIONSTAB_H
#define DAILYMOTIONSUBSCRIPTIONSTAB_H

#include "abstracttab.h"

class DailymotionSubscriptionListModel;
class ListView;
class QModelIndex;
class QMenu;
class QAction;
class QLabel;
class QGridLayout;

class DailymotionSubscriptionsTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit DailymotionSubscriptionsTab(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onSubscriptionsLoaded();
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showContextMenu(const QPoint &pos);
    void unsubscribe();
    void showUserChannel(const QString &userId);
    void showSubscriptionVideos();

private:
    DailymotionSubscriptionListModel *m_model;
    ListView *m_listView;
    QMenu *m_contextMenu;
    QAction *m_unsubscribeAction;
    QAction *m_videosAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // DAILYMOTIONSUBSCRIPTIONSTAB_H
