#ifndef DAILYMOTIONGROUPLISTWINDOW_H
#define DAILYMOTIONGROUPLISTWINDOW_H

#include "stackedwindow.h"
#include "../base/groupitem.h"

class DailymotionGroupListModel;
class ListView;
class QLabel;
class QModelIndex;

class DailymotionGroupListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit DailymotionGroupListWindow(QWidget *parent);
    void setGroupFeed(const QUrl &feed);
    void search(const QString &query, Queries::QueryOrder order);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showGroup(QSharedPointer<GroupItem> group);

private:
    ListView *m_listView;
    DailymotionGroupListModel *m_model;
    QLabel *m_noResultsLabel;
};

#endif // DAILYMOTIONGROUPLISTWINDOW_H
