#ifndef YOUTUBEUSERLISTTAB_H
#define YOUTUBEUSERLISTTAB_H

#include "abstracttab.h"

class YouTubeUserListModel;
class ListView;
class QLabel;
class QGridLayout;
class QAction;
class QModelIndex;
class QUrl;

class YouTubeUserListTab : public AbstractTab
{
    Q_OBJECT

public:
    explicit YouTubeUserListTab(const QString &userId, QWidget *parent = 0);
    void setFeed(const QUrl &feed);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void onItemClicked(const QModelIndex &index);
    void showUserChannel(const QString &userId);
    void showSubscriptionVideos();

private:
    QString m_userId;
    YouTubeUserListModel *m_model;
    ListView *m_listView;
    QAction *m_videosAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEUSERLISTTAB_H
