#include "sharingdialog.h"
#include "textlistdelegate.h"
#include "../base/selectionmodels.h"
#include <QListView>
#include <QVBoxLayout>

SharingDialog::SharingDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_model(new SharingModel(this)),
    m_listView(new QListView(this))
{
    this->setWindowTitle(tr("Share video"));
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(Qt::DisplayRole, Qt::AlignCenter, m_listView));
    m_listView->setMinimumHeight(m_listView->sizeHintForRow(0) * 5);

    QVBoxLayout *vbox = new QVBoxLayout(this);
    vbox->addWidget(m_listView);

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
}

Services::SharingService SharingDialog::currentValue() const {
    return static_cast<Services::SharingService>(m_model->value(m_listView->currentIndex().row()).toInt());
}

void SharingDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(static_cast<Services::SharingService>(m_model->value(index.row()).toInt()));
    this->accept();
}
