#ifndef SEARCHDIALOG_H
#define SEARCHDIALOG_H

#include "abstractdialog.h"
#include "../base/enums.h"

class SearchListModel;
class SearchHistoryDialog;
class VideoServiceSelector;
class SearchTypeSelector;
class SearchOrderSelector;
class SearchTimeSelector;
class SearchDurationSelector;
class LanguageSelector;
class QLineEdit;
class QPushButton;
class QScrollArea;
class QDialogButtonBox;
class QGridLayout;

class SearchDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit SearchDialog(QWidget *parent = 0);

private slots:
    void showSearchHistory();
    void parseSearchQuery();
    void onServiceChanged(Services::VideoService service);
    void onSearchTypeChanged(Queries::QueryType type);
    void onSearchTextChanged(const QString &text);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

signals:
    void search(const QString &query);
    void goToVideo(const QString &url);
    
private:
    QLineEdit *m_searchEdit;
    VideoServiceSelector *m_searchServiceSelector;
    SearchTypeSelector *m_searchTypeSelector;
    SearchOrderSelector *m_searchOrderSelector;
    SearchTimeSelector *m_searchTimeSelector;
    SearchDurationSelector *m_searchDurationSelector;
    LanguageSelector *m_searchLanguageSelector;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_historyButton;
    QPushButton *m_searchButton;
    QScrollArea *m_scrollArea;
    SearchListModel *m_model;
    SearchHistoryDialog *m_historyDialog;
    QGridLayout *m_grid;
};

#endif // SEARCHDIALOG_H
