#include "networkproxydialog.h"
#include "networkproxytypeselector.h"
#include "../base/settings.h"
#include <QCheckBox>
#include <QLineEdit>
#include <QGridLayout>
#include <QScrollArea>
#include <QLabel>
#include <QDialogButtonBox>
#include <QIntValidator>

NetworkProxyDialog::NetworkProxyDialog(QWidget *parent) :
    AbstractDialog(parent),
    m_proxyCheckbox(new QCheckBox(tr("Use network proxy"), this)),
    m_proxyWidget(new QWidget(this)),
    m_proxyTypeSelector(new NetworkProxyTypeSelector(tr("Proxy type"), this)),
    m_hostEdit(new QLineEdit(this)),
    m_portEdit(new QLineEdit(this)),
    m_userEdit(new QLineEdit(this)),
    m_passEdit(new QLineEdit(this)),
    m_scrollArea(new QScrollArea(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Save, Qt::Vertical, this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Network proxy"));
    this->setAttribute(Qt::WA_DeleteOnClose, false);

    m_hostEdit->setMinimumWidth(380);
    m_portEdit->setValidator(new QIntValidator(0, 100000, this));
    m_passEdit->setEchoMode(QLineEdit::Password);

    QGridLayout *proxyGrid = new QGridLayout(m_proxyWidget);
    proxyGrid->setContentsMargins(0, 0, 0, 0);
    proxyGrid->addWidget(m_proxyTypeSelector, 0, 0, 1, 2);
    proxyGrid->addWidget(new QLabel(tr("Host"), this), 1, 0, 1, 1);
    proxyGrid->addWidget(new QLabel(tr("Port"), this), 1, 1, 1, 1);
    proxyGrid->addWidget(m_hostEdit, 2, 0, 1, 1);
    proxyGrid->addWidget(m_portEdit, 2, 1, 1, 1);
    proxyGrid->addWidget(new QLabel(tr("Username"), this), 3, 0, 1, 2);
    proxyGrid->addWidget(m_userEdit, 4, 0, 1, 2);
    proxyGrid->addWidget(new QLabel(tr("Password"), this), 5, 0, 1, 2);
    proxyGrid->addWidget(m_passEdit, 6, 0, 1, 2);

    QWidget *scrollWidget = new QWidget(this);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);
    vbox->setContentsMargins(0, 0, 0, 0);
    vbox->addWidget(m_proxyCheckbox);
    vbox->addWidget(m_proxyWidget);
    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    m_scrollArea->setWidget(scrollWidget);

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(saveSettings()));
    this->connect(m_proxyCheckbox, SIGNAL(toggled(bool)), m_proxyWidget, SLOT(setEnabled(bool)));
    this->connect(m_proxyCheckbox, SIGNAL(toggled(bool)), this, SLOT(onProxyCheckboxToggled(bool)));

    this->loadSettings();
    this->onOrientationChanged();
}

void NetworkProxyDialog::setLandscapeLayout() {
    this->setFixedHeight(340);
    m_hostEdit->setMinimumWidth(380);
    m_buttonBox->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1);
    }
}

void NetworkProxyDialog::setPortraitLayout() {
    this->setFixedHeight(600);
    m_hostEdit->setMinimumWidth(280);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0);
    }
}

void NetworkProxyDialog::loadSettings() {
    m_proxyCheckbox->setChecked(!Settings::instance()->networkProxyHostName().isEmpty());
    m_proxyTypeSelector->setValue(Settings::instance()->networkProxyType());
    m_hostEdit->setText(Settings::instance()->networkProxyHostName());
    m_portEdit->setText(QString::number(Settings::instance()->networkProxyPort()));
    m_userEdit->setText(Settings::instance()->networkProxyUser());
    m_passEdit->setText(Settings::instance()->networkProxyPassword());
    m_proxyWidget->setEnabled(m_proxyCheckbox->isChecked());
}

void NetworkProxyDialog::saveSettings() {
    Settings::instance()->setNetworkProxyType(m_proxyTypeSelector->currentValue());
    Settings::instance()->setNetworkProxyHostName(m_hostEdit->text());
    Settings::instance()->setNetworkProxyPort(m_portEdit->text().toUInt());
    Settings::instance()->setNetworkProxyUser(m_userEdit->text());
    Settings::instance()->setNetworkProxyPassword(m_passEdit->text());
    Settings::instance()->setNetworkProxy();
    this->accept();
}

void NetworkProxyDialog::onProxyCheckboxToggled(bool checked) {
    if (!checked) {
        m_hostEdit->clear();
        m_portEdit->setText(QString::number(80));
        m_userEdit->clear();
        m_passEdit->clear();
    }
}
