#ifndef HOMEWINDOW_H
#define HOMEWINDOW_H

#include "stackedwindow.h"
#include "../base/videoitem.h"

class NavButton;
class QGridLayout;
class QAction;

class HomeWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit HomeWindow(QWidget *parent = 0);

public slots:
    void search(const QString &query);
    void search(const QString &query,
                Services::VideoService service,
                Queries::QueryType type = Queries::Videos,
                Queries::QueryOrder order = Queries::Relevance,
                Queries::TimeFilter timeFilter = Queries::AllTime,
                Queries::DurationFilter durationFilter = Queries::Any,
                const QString &languageFilter = "all");
    void videoSearch(const QString &query,
                     Services::VideoService service,
                     Queries::QueryOrder order = Queries::Relevance,
                     Queries::TimeFilter timeFilter = Queries::AllTime,
                     Queries::DurationFilter durationFilter = Queries::Any,
                     const QString &languageFilter = "all");
    void playlistSearch(const QString &query, Services::VideoService service, Queries::QueryOrder order = Queries::Relevance);
    void groupSearch(const QString &query, Services::VideoService service, Queries::QueryOrder order = Queries::Relevance);
    void userSearch(const QString &query, Services::VideoService service);
    void showYouTubeVideo(QSharedPointer<VideoItem> video);
    void showDailymotionVideo(QSharedPointer<VideoItem> video);
    void showVimeoVideo(QSharedPointer<VideoItem> video);
    void display(const QStringList &urls);
    void display(const QString &url);
    void play(const QStringList &urls);
    void play(const QString &url);

private slots:
    void showSettingsDialog();
    void showAboutDialog();
    void showMyChannel(Services::VideoService service = Services::NoService);
    void showLatestVideos(Services::VideoService service = Services::NoService);
    void showCategoriesDialog(Services::VideoService service = Services::NoService);
    void showCategoryVideos(Services::VideoService service, const QString &title, const QUrl &feed);
    void showSocialVideos();
    void showSearchDialog();
    void showPlaybackQueue();
    void showTransfers();
    void showArchive();
    void showAccounts();
    void showLinkGoogleAccountDialog();
    void showFacebookAuthDialog();
    void showTwitterAuthDialog();

private:
    void setLandscapeLayout();
    void setPortraitLayout();
    void showYouTubeChannel();
    void showDailymotionChannel();
    void showVimeoChannel();
    void showLatestYouTubeVideos();
    void showLatestDailymotionVideos();
    void showLatestVimeoVideos();
    void showSignInDialog();
    void showSocialSignInDialog();

private:
    NavButton *m_myChannelButton;
    NavButton *m_latestButton;
    NavButton *m_categoriesButton;
    NavButton *m_socialButton;
    NavButton *m_searchButton;
    NavButton *m_queueButton;
    NavButton *m_transfersButton;
    NavButton *m_archiveButton;
    NavButton *m_accountsButton;
    QAction *m_accountsAction;
    QAction *m_settingsAction;
    QAction *m_aboutAction;
    QGridLayout *m_grid;
};

#endif // HOMEWINDOW_H
