#include "dailymotiongrouplisttab.h"
#include "dailymotiongrouplistdelegate.h"
#include "dailymotionvideolistwindow.h"
#include "listview.h"
#include "../base/notifications.h"
#include "../base/windowstack.h"
#include "../base/dailymotiongrouplistmodel.h"
#include <QLabel>
#include <QGridLayout>

DailymotionGroupListTab::DailymotionGroupListTab(QWidget *parent) :
    AbstractTab(parent),
    m_listView(new ListView(this)),
    m_model(new DailymotionGroupListModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No groups found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->setContentsMargins(0, 0, 0, 0);
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new DailymotionGroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMoreGroups()));

    this->onOrientationChanged();
}

void DailymotionGroupListTab::setGroupFeed(const QUrl &feed) {
    m_model->getGroups(feed);
}

void DailymotionGroupListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionGroupListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionGroupListTab::onLoadingChanged(bool loading) {
    Notifications::toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void DailymotionGroupListTab::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void DailymotionGroupListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showGroup(m_model->get(index.row()));
    }
}

void DailymotionGroupListTab::showGroup(QSharedPointer<GroupItem> group) {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(WindowStack::instance()->currentWindow());
    window->setWindowTitle(group.data()->title());
    window->getGroupVideos(group);
    window->show();
}
