#include "videolauncher.h"
#include "settings.h"
#include <qplatformdefs.h>
#include <QUrl>
#ifndef SYMBIAN_OS
#include <QProcess>
#endif
#ifdef Q_WS_MAEMO_5
#include <QDBusConnection>
#include <QDBusMessage>
#include <QDBusInterface>
#elif defined (MEEGO_EDITION_HARMATTAN)
#include <contentaction/contentaction.h>
#elif defined (SYMBIAN_OS)
#include <QTemporaryFile>
#include <QDesktopServices>
#include <QTimer>
#include <QDir>
#endif

VideoLauncher* launcherInstance = 0;

VideoLauncher::VideoLauncher(QObject *parent) :
    QObject(parent)
{
    if (!launcherInstance) {
        launcherInstance = this;
    }
}

VideoLauncher* VideoLauncher::instance() {
    return launcherInstance;
}

void VideoLauncher::launchVideo(const QUrl &url) {
#ifdef Q_OS_LINUX
    if (Settings::instance()->mediaPlayer() == "other") {
        QStringList args = Settings::instance()->mediaPlayerCommand().split(' ', QString::SkipEmptyParts);
        QProcess *player = new QProcess;
        QObject::connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start(args.takeFirst(), args << QByteArray::fromPercentEncoding(url.toString().toUtf8()));
    }
    else if (Settings::instance()->mediaPlayer() == "mplayer") {
        QStringList args;
        args << "-cache" << "2048" << "-fs" << QByteArray::fromPercentEncoding(url.toString().toUtf8());
        QProcess *player = new QProcess;
        QObject::connect(player, SIGNAL(finished(int, QProcess::ExitStatus)), player, SLOT(deleteLater()));
        player->start("/usr/bin/mplayer", args);
    }
#endif
#ifdef MEEGO_EDITION_HARMATTAN
    else if (Settings::instance()->mediaPlayer() == "mediaplayer") {
        ContentAction::Action::launcherAction("videosuiteinterface.desktop", QStringList(url.toString())).trigger();
    }
    else if (Settings::instance()->mediaPlayer() == "kmplayer") {
        ContentAction::Action::launcherAction("kmplayer.desktop", QStringList(url.toString())).trigger();
    }
#endif
    else {
#ifdef Q_WS_MAEMO_5
        QDBusConnection bus = QDBusConnection::sessionBus();
        QDBusInterface dbus_iface("com.nokia." + Settings::instance()->mediaPlayer(), "/com/nokia/" + Settings::instance()->mediaPlayer(), "com.nokia." + Settings::instance()->mediaPlayer(), bus);
        dbus_iface.call("mime_open", url.toString());
#elif defined (SYMBIAN_OS)
        QTemporaryFile *temp = new QTemporaryFile;
        temp->setFileName(QDir::tempPath() + "/cutetube.ram");

        if ((temp->open()) && (temp->write(QByteArray::fromPercentEncoding(url.toString().toUtf8())) > 0)) {
            QDesktopServices::openUrl(QUrl::fromLocalFile(temp->fileName()));
        }

        temp->close();
        QTimer::singleShot(5000, temp, SLOT(deleteLater()));
#endif
    }
}
